/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.factory.Nd4j;

public class Step
extends BaseTransformOp {
    private final double cutoff;

    public Step() {
        this.cutoff = 0.0;
    }

    public Step(INDArray x, INDArray z) {
        super(x, z);
        this.cutoff = 0.0;
    }

    public Step(INDArray x, INDArray z, int n) {
        super(x, z, n);
        this.cutoff = 0.0;
    }

    public Step(INDArray x, INDArray y, INDArray z, int n) {
        super(x, y, z, n);
        this.cutoff = 0.0;
    }

    public Step(INDArray x) {
        super(x);
        this.cutoff = 0.0;
    }

    public Step(INDArray x, INDArray z, double cutoff) {
        super(x, z);
        this.cutoff = cutoff;
    }

    public Step(INDArray x, INDArray z, int n, double cutoff) {
        super(x, z, n);
        this.cutoff = cutoff;
    }

    public Step(INDArray x, INDArray y, INDArray z, int n, double cutoff) {
        super(x, y, z, n);
        this.cutoff = cutoff;
    }

    public Step(INDArray x, double cutoff) {
        super(x);
        this.cutoff = cutoff;
    }

    @Override
    public String name() {
        return "step";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        return origin.realComponent().doubleValue() > this.cutoff ? Nd4j.createDouble(1.0, 0.0) : Nd4j.createDouble(0.0, 0.0);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        return origin.realComponent().doubleValue() > this.cutoff ? Nd4j.createDouble(1.0, 0.0) : Nd4j.createDouble(0.0, 0.0);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        return origin.realComponent().doubleValue() > this.cutoff ? Nd4j.createDouble(1.0, 0.0) : Nd4j.createDouble(0.0, 0.0);
    }

    @Override
    public float op(float origin, float other) {
        return (double)origin > this.cutoff ? 1.0f : 0.0f;
    }

    @Override
    public double op(double origin, double other) {
        return origin > this.cutoff ? 1.0 : 0.0;
    }

    @Override
    public double op(double origin) {
        return origin > this.cutoff ? 1.0 : 0.0;
    }

    @Override
    public float op(float origin) {
        return (double)origin > this.cutoff ? 1.0f : 0.0f;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        return origin.realComponent().doubleValue() > this.cutoff ? Nd4j.createDouble(1.0, 0.0) : Nd4j.createDouble(0.0, 0.0);
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new Step(this.x.vectorAlongDimension(index, dimension), this.y.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length(), this.cutoff);
        }
        return new Step(this.x.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length(), this.cutoff);
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new Step(this.x.tensorAlongDimension(index, dimension), this.y.tensorAlongDimension(index, dimension), this.z.tensorAlongDimension(index, dimension), xAlongDimension.length(), this.cutoff);
        }
        return new Step(this.x.tensorAlongDimension(index, dimension), this.z.tensorAlongDimension(index, dimension), xAlongDimension.length(), this.cutoff);
    }
}

