/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseAccumulation;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.util.ComplexUtil;

public class NormMax
extends BaseAccumulation {
    public NormMax() {
    }

    public NormMax(INDArray x, INDArray y, INDArray z, int n) {
        super(x, y, z, n);
    }

    public NormMax(INDArray x, INDArray y, int n) {
        super(x, y, n);
    }

    public NormMax(INDArray x) {
        super(x);
    }

    public NormMax(INDArray x, INDArray y) {
        super(x, y);
    }

    @Override
    public void update(Number result) {
        double abs = FastMath.abs((double)result.doubleValue());
        this.currentResult = abs > this.currentResult.doubleValue() ? (Number)abs : (Number)this.currentResult();
        ++this.numProcessed;
    }

    @Override
    public void update(IComplexNumber result) {
        IComplexNumber abs = ComplexUtil.abs(result);
        if (abs.absoluteValue().doubleValue() > this.currentComplexResult.absoluteValue().doubleValue()) {
            this.currentComplexResult = abs;
        }
        ++this.numProcessed;
    }

    @Override
    public Number zero() {
        return 0.0;
    }

    @Override
    public IComplexNumber zeroComplex() {
        return Nd4j.createComplexNumber(0.0, 0.0);
    }

    @Override
    public String name() {
        return "normmax";
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new NormMax(xAlongDimension, this.y.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new NormMax(this.x.vectorAlongDimension(index, dimension));
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new NormMax(xAlongDimension, this.y.tensorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new NormMax(this.x.tensorAlongDimension(index, dimension));
    }
}

