/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.blas;

import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.ndarray.INDArray;

public class BlasBufferUtil {
    public static int getBlasOffset(INDArray arr) {
        return arr.offset();
    }

    public static int getBlasStride(INDArray arr) {
        if (arr instanceof IComplexNDArray) {
            return arr.elementWiseStride() / 2;
        }
        return arr.elementWiseStride();
    }

    public static float[] getFloatData(INDArray buf) {
        if (buf.data().dataType() != DataBuffer.Type.FLOAT) {
            throw new IllegalArgumentException("Float data must be obtained from a float buffer");
        }
        if (buf.data().allocationMode() == DataBuffer.AllocationMode.HEAP) {
            return buf.data().asFloat();
        }
        float[] ret = new float[buf.length()];
        INDArray linear = buf.linearView();
        for (int i = 0; i < buf.length(); ++i) {
            ret[i] = linear.getFloat(i);
        }
        return ret;
    }

    public static double[] getDoubleData(INDArray buf) {
        if (buf.data().dataType() != DataBuffer.Type.DOUBLE) {
            throw new IllegalArgumentException("Double data must be obtained from a double buffer");
        }
        if (buf.data().allocationMode() == DataBuffer.AllocationMode.HEAP) {
            return buf.data().asDouble();
        }
        double[] ret = new double[buf.length()];
        INDArray linear = buf.linearView();
        for (int i = 0; i < buf.length(); ++i) {
            ret[i] = linear.getDouble(i);
        }
        return ret;
    }

    public static char getCharForTranspose(INDArray arr) {
        return 'N';
    }

    public static int getStrideForOrdering(INDArray arr) {
        if (arr.ordering() == 'f') {
            return BlasBufferUtil.getBlasStride(arr);
        }
        if (arr instanceof IComplexNDArray) {
            return arr.stride(1) / 2;
        }
        return arr.stride(1);
    }

    public static int getDimension(INDArray arr, boolean defaultRows) {
        if (arr.isVector()) {
            return defaultRows ? arr.rows() : arr.columns();
        }
        if (arr.ordering() == 'c') {
            return defaultRows ? arr.columns() : arr.rows();
        }
        return defaultRows ? arr.rows() : arr.columns();
    }

    public static int getLd(INDArray arr) {
        if (arr.isVector()) {
            return arr.size(0);
        }
        return arr.ordering() == 'c' ? arr.size(1) : arr.size(0);
    }

    public static float[] getFloatData(DataBuffer buf) {
        if (buf.allocationMode() == DataBuffer.AllocationMode.HEAP) {
            return buf.asFloat();
        }
        float[] ret = new float[buf.length()];
        for (int i = 0; i < buf.length(); ++i) {
            ret[i] = buf.getFloat(i);
        }
        return ret;
    }

    public static double[] getDoubleData(DataBuffer buf) {
        if (buf.allocationMode() == DataBuffer.AllocationMode.HEAP) {
            return buf.asDouble();
        }
        double[] ret = new double[buf.length()];
        for (int i = 0; i < buf.length(); ++i) {
            ret[i] = buf.getDouble(i);
        }
        return ret;
    }

    public static void setData(float[] data, INDArray toSet) {
        if (toSet.data().dataType() != DataBuffer.Type.FLOAT) {
            throw new IllegalArgumentException("Unable to set double data for type " + (Object)((Object)toSet.data().dataType()));
        }
        if (toSet.data().allocationMode() == DataBuffer.AllocationMode.HEAP) {
            Object array = toSet.data().array();
            if (array == data) {
                return;
            }
            float[] d = (float[])array;
            if (toSet.offset() == 0 && toSet.length() == data.length) {
                System.arraycopy(data, 0, d, 0, d.length);
            } else {
                int count = 0;
                for (int i = 0; i < data.length; ++i) {
                    int dIndex = toSet.offset() + i * toSet.majorStride();
                    d[dIndex] = data[count++];
                }
            }
        } else {
            DataBuffer underlyingData = toSet.data();
            if (data.length == toSet.length() && toSet.offset() == 0) {
                for (int i = 0; i < toSet.length(); ++i) {
                    underlyingData.put(i, data[i]);
                }
            } else {
                int count = 0;
                for (int i = 0; i < data.length; ++i) {
                    int dIndex = toSet.offset() + i * toSet.majorStride();
                    underlyingData.put(dIndex, data[count++]);
                }
            }
        }
    }

    public static void setData(double[] data, INDArray toSet) {
        if (toSet.data().dataType() != DataBuffer.Type.DOUBLE) {
            throw new IllegalArgumentException("Unable to set double data for type " + (Object)((Object)toSet.data().dataType()));
        }
        if (toSet.data().allocationMode() == DataBuffer.AllocationMode.HEAP) {
            Object array = toSet.data().array();
            if (array == data) {
                return;
            }
            double[] d = (double[])array;
            if (toSet.offset() == 0 && toSet.length() == data.length) {
                System.arraycopy(data, 0, d, 0, d.length);
            } else {
                int count = 0;
                for (int i = 0; i < data.length; ++i) {
                    int dIndex = toSet.offset() + i * toSet.majorStride();
                    d[dIndex] = data[count++];
                }
            }
        } else {
            DataBuffer underlyingData = toSet.data();
            if (data.length == toSet.length() && toSet.offset() == 0) {
                for (int i = 0; i < toSet.length(); ++i) {
                    underlyingData.put(i, data[i]);
                }
            } else {
                int count = 0;
                for (int i = 0; i < data.length; ++i) {
                    int dIndex = toSet.offset() + i * toSet.majorStride();
                    underlyingData.put(dIndex, data[count++]);
                }
            }
        }
    }
}

