/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.lossfunctions;

import org.nd4j.linalg.api.activation.ActivationFunction;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.ops.transforms.Transforms;

public class LossFunctions {
    public static double score(INDArray labels, LossFunction lossFunction, INDArray output, double l2, boolean useRegularization) {
        assert (!Nd4j.hasInvalidNumber(output)) : "Invalid output on labels. Must not contain nan or infinite numbers.";
        double ret = 0.0;
        double reg = 0.5 * l2;
        INDArray z = output;
        assert (labels.length() == output.length()) : "Output and labels must be same length";
        switch (lossFunction) {
            case RECONSTRUCTION_CROSSENTROPY: {
                INDArray xEntLogZ2 = Transforms.log(z.dup());
                INDArray xEntOneMinusLabelsOut2 = labels.rsub(1);
                INDArray xEntOneMinusLogOneMinusZ2 = Transforms.log(z).rsubi(1);
                ret = labels.mul(xEntLogZ2).add(xEntOneMinusLabelsOut2).muli(xEntOneMinusLogOneMinusZ2).sum(1).sum(Integer.MAX_VALUE).getDouble(0);
                break;
            }
            case MCXENT: {
                INDArray columnSums = labels.mul(Transforms.log(z));
                ret = columnSums.mean(1).mean(Integer.MAX_VALUE).getDouble(0);
                break;
            }
            case XENT: {
                INDArray xEntLogZ = Transforms.log(z);
                INDArray xEntOneMinusLabelsOut = labels.rsub(1);
                INDArray xEntOneMinusLogOneMinusZ = Transforms.log(z).rsubi(1);
                ret = labels.mul(xEntLogZ).add(xEntOneMinusLabelsOut).muli(xEntOneMinusLogOneMinusZ).sum(1).sum(Integer.MAX_VALUE).getDouble(0);
                break;
            }
            case RMSE_XENT: {
                INDArray rmseXentDiff = labels.sub(z);
                INDArray squaredrmseXentDiff = Transforms.pow(rmseXentDiff, 2);
                INDArray sqrt = Transforms.sqrt(squaredrmseXentDiff);
                ret = sqrt.sum(1).sum(Integer.MAX_VALUE).getDouble(0);
                break;
            }
            case MSE: {
                INDArray mseDelta = labels.sub(z);
                ret = 0.5 * Transforms.pow(mseDelta, 2).sum(1).sum(Integer.MAX_VALUE).getDouble(0);
                break;
            }
            case EXPLL: {
                INDArray expLLLogZ = Transforms.log(z);
                ret = z.sub(labels.mul(expLLLogZ)).sum(1).sum(Integer.MAX_VALUE).getDouble(0);
                break;
            }
            case SQUARED_LOSS: {
                ret = Transforms.pow(labels.sub(z), 2).sum(1).sum(Integer.MAX_VALUE).getDouble(0);
                break;
            }
            case NEGATIVELOGLIKELIHOOD: {
                ret = -Nd4j.mean(Nd4j.sum(labels.mul(Transforms.log(z)).addi(labels.rsub(1).muli(Transforms.log(z.rsub(1)))), 1)).getDouble(0);
            }
        }
        if (useRegularization) {
            ret += reg;
        }
        return ret /= (double)labels.rows();
    }

    public static double reconEntropy(INDArray input, INDArray hBias, INDArray vBias, INDArray W, ActivationFunction activationFunction) {
        INDArray preSigH = input.mmul(W).addiRowVector(hBias);
        INDArray sigH = (INDArray)activationFunction.apply(preSigH);
        assert (!Nd4j.hasInvalidNumber(sigH));
        INDArray preSigV = sigH.mmul(W.transpose()).addiRowVector(vBias);
        INDArray sigV = (INDArray)activationFunction.apply(preSigV);
        assert (!Nd4j.hasInvalidNumber(sigH));
        INDArray inner = input.mul(Transforms.log(sigV)).addi(input.rsub(1).muli(Transforms.log(sigV.rsub(1))));
        INDArray rows = inner.sum(1);
        INDArray mean = rows.mean(Integer.MAX_VALUE);
        double ret = mean.getDouble(0);
        return ret /= (double)input.rows();
    }

    public static enum LossFunction {
        MSE,
        EXPLL,
        XENT,
        MCXENT,
        RMSE_XENT,
        SQUARED_LOSS,
        RECONSTRUCTION_CROSSENTROPY,
        NEGATIVELOGLIKELIHOOD;

    }
}

