/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.lossfunctions;

import java.util.Arrays;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.ops.transforms.Transforms;

public class LossFunctions {
    public static double score(INDArray labels, LossFunction lossFunction, INDArray z, double l2, boolean useRegularization) {
        double ret = 0.0;
        double reg = 0.5 * l2;
        if (!Arrays.equals(labels.shape(), z.shape())) {
            throw new IllegalArgumentException("Output and labels must be same length");
        }
        switch (lossFunction) {
            case CUSTOM: {
                throw new IllegalStateException("Unable to score custom operation. Please define an alternative mechanism");
            }
            case RECONSTRUCTION_CROSSENTROPY: {
                INDArray xEntLogZ2 = Transforms.log(z);
                INDArray xEntOneMinusLabelsOut2 = labels.rsub(1);
                INDArray xEntOneMinusLogOneMinusZ2 = Transforms.log(z).rsubi(1);
                ret = labels.mul(xEntLogZ2).add(xEntOneMinusLabelsOut2).muli(xEntOneMinusLogOneMinusZ2).sum(1).mean(Integer.MAX_VALUE).getDouble(0);
                break;
            }
            case MCXENT: {
                INDArray columnSums = labels.mul(Transforms.log(z));
                ret = columnSums.mean(1).mean(Integer.MAX_VALUE).getDouble(0);
                break;
            }
            case XENT: {
                INDArray xEntLogZ = Transforms.log(z);
                INDArray xEntOneMinusLabelsOut = labels.rsub(1);
                INDArray xEntOneMinusLogOneMinusZ = Transforms.log(z).rsubi(1);
                ret = labels.mul(xEntLogZ).add(xEntOneMinusLabelsOut).muli(xEntOneMinusLogOneMinusZ).sum(1).sum(Integer.MAX_VALUE).getDouble(0);
                break;
            }
            case RMSE_XENT: {
                INDArray rmseXentDiff = labels.sub(z);
                INDArray squaredrmseXentDiff = Transforms.pow(rmseXentDiff, 2.0);
                INDArray sqrt = Transforms.sqrt(squaredrmseXentDiff);
                ret = sqrt.sum(1).sum(Integer.MAX_VALUE).getDouble(0);
                break;
            }
            case MSE: {
                INDArray mseDelta = labels.sub(z);
                ret = 0.5 * Transforms.pow(mseDelta, 2).sum(1).sum(Integer.MAX_VALUE).getDouble(0);
                break;
            }
            case EXPLL: {
                INDArray expLLLogZ = Transforms.log(z);
                ret = z.sub(labels.mul(expLLLogZ)).sum(1).sum(Integer.MAX_VALUE).getDouble(0);
                break;
            }
            case SQUARED_LOSS: {
                ret = Transforms.pow(labels.sub(z), 2).sum(1).sum(Integer.MAX_VALUE).getDouble(0);
                break;
            }
            case NEGATIVELOGLIKELIHOOD: {
                ret = -Nd4j.mean(Nd4j.sum(labels.mul(Transforms.log(z)).addi(labels.rsub(1).muli(Transforms.log(z.rsub(1)))), 1)).getDouble(0);
            }
        }
        if (useRegularization) {
            ret += reg;
        }
        return ret /= (double)labels.rows();
    }

    public static enum LossFunction {
        MSE,
        EXPLL,
        XENT,
        MCXENT,
        RMSE_XENT,
        SQUARED_LOSS,
        RECONSTRUCTION_CROSSENTROPY,
        NEGATIVELOGLIKELIHOOD,
        CUSTOM;

    }
}

