/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.indexing;

import java.util.ArrayList;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.transforms.LinearIndex;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.util.ArrayUtil;
import org.nd4j.linalg.util.Shape;

public class Indices {
    public static int rowNumber(int index, INDArray arr) {
        int vectors;
        double otherTest = Double.valueOf(index) / Double.valueOf(arr.size(-1));
        int test = (int)Math.floor(otherTest);
        if (test >= (vectors = arr.vectorsAlongDimension(-1))) {
            return vectors - 1;
        }
        return test;
    }

    public static int linearOffset(int index, INDArray arr) {
        if (arr.ordering() == 'c') {
            double otherTest = Double.valueOf(index) % Double.valueOf(arr.size(-1));
            int test = (int)Math.floor(otherTest);
            INDArray vec = arr.vectorAlongDimension(test, -1);
            int otherDim = arr.vectorAlongDimension(test, -1).offset() + index;
            return otherDim;
        }
        int majorStride = arr.stride(-2);
        int vectorsAlongDimension = arr.vectorsAlongDimension(-1);
        double rowCalc = (double)(index * majorStride) / (double)arr.length();
        int floor = (int)Math.floor(rowCalc);
        INDArray arrVector = arr.vectorAlongDimension(floor, -1);
        int columnIndex = index % arr.size(-1);
        int retOffset = arrVector.linearIndex(columnIndex);
        return retOffset;
    }

    public static int[] linearIndices(INDArray arr) {
        LinearIndex index = new LinearIndex(arr, arr.dup(), true);
        Nd4j.getExecutioner().iterateOverAllRows(index);
        return index.getIndices();
    }

    public static int[] offsets(NDArrayIndex ... indices) {
        int[] ret = new int[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            int offset = indices[i].offset();
            ret[i] = offset == 0 && i > 0 && i < indices.length - 1 ? 1 : indices[i].offset();
        }
        if (ret.length == 1) {
            ret = new int[]{ret[0], 0};
        }
        return ret;
    }

    public static NDArrayIndex[] fillIn(int[] shape, NDArrayIndex ... indexes) {
        if (shape.length == indexes.length) {
            return indexes;
        }
        NDArrayIndex[] newIndexes = new NDArrayIndex[shape.length];
        System.arraycopy(indexes, 0, newIndexes, 0, indexes.length);
        for (int i = indexes.length; i < shape.length; ++i) {
            newIndexes[i] = NDArrayIndex.interval(0, shape[i]);
        }
        return newIndexes;
    }

    public static NDArrayIndex[] adjustIndices(int[] originalShape, NDArrayIndex ... indexes) {
        if (Shape.isVector(originalShape) && indexes.length == 1) {
            return indexes;
        }
        if (indexes.length < originalShape.length) {
            indexes = Indices.fillIn(originalShape, indexes);
        }
        if (indexes.length > originalShape.length) {
            NDArrayIndex[] ret = new NDArrayIndex[originalShape.length];
            System.arraycopy(indexes, 0, ret, 0, originalShape.length);
            return ret;
        }
        if (indexes.length == originalShape.length) {
            return indexes;
        }
        for (int i = 0; i < indexes.length; ++i) {
            if (indexes[i].end() < originalShape[i] && !(indexes[i] instanceof NDArrayIndex.NDArrayIndexAll)) continue;
            indexes[i] = NDArrayIndex.interval(0, originalShape[i] - 1);
        }
        return indexes;
    }

    public static int[] strides(char ordering, NDArrayIndex ... indexes) {
        return Nd4j.getStrides(Indices.shape(indexes), ordering);
    }

    public static int[] shape(NDArrayIndex ... indices) {
        int[] ret = new int[indices.length];
        for (int i = 0; i < ret.length; ++i) {
            int[] currIndices = indices[i].indices();
            int end = currIndices[currIndices.length - 1] + 1;
            int begin = currIndices[0];
            ret[i] = Math.abs(end - begin);
        }
        ArrayList<Integer> nonZeros = new ArrayList<Integer>();
        for (int i = 0; i < ret.length; ++i) {
            if (ret[i] <= 0) continue;
            nonZeros.add(ret[i]);
        }
        return ArrayUtil.toArray(nonZeros);
    }

    public static boolean isContiguous(NDArrayIndex ... indexes) {
        return Indices.isContiguous(1, indexes);
    }

    public static boolean isContiguous(int diff, NDArrayIndex ... indexes) {
        if (indexes.length < 1) {
            return true;
        }
        boolean contiguous = Indices.isContiguous(indexes[0].indices(), diff);
        for (int i = 1; i < indexes.length; ++i) {
            contiguous = contiguous && Indices.isContiguous(indexes[i].indices(), diff);
        }
        return contiguous;
    }

    public static boolean isContiguous(int[] indices) {
        return Indices.isContiguous(indices, 1);
    }

    public static boolean isContiguous(int[] indices, int diff) {
        if (indices.length < 1) {
            return true;
        }
        for (int i = 1; i < indices.length; ++i) {
            if (Math.abs(indices[i] - indices[i - 1]) <= diff) continue;
            return false;
        }
        return true;
    }

    public static NDArrayIndex[] createFromStartAndEnd(INDArray start, INDArray end) {
        if (start.length() != end.length()) {
            throw new IllegalArgumentException("Start length must be equal to end length");
        }
        NDArrayIndex[] indexes = new NDArrayIndex[start.length()];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = NDArrayIndex.interval(start.getInt(i), end.getInt(i));
        }
        return indexes;
    }

    public static NDArrayIndex[] createFromStartAndEnd(INDArray start, INDArray end, boolean inclusive) {
        if (start.length() != end.length()) {
            throw new IllegalArgumentException("Start length must be equal to end length");
        }
        NDArrayIndex[] indexes = new NDArrayIndex[start.length()];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = NDArrayIndex.interval(start.getInt(i), end.getInt(i), inclusive);
        }
        return indexes;
    }

    public static int[] shape(int[] shape, int[] offsets, NDArrayIndex ... indices) {
        if (indices.length > shape.length) {
            return shape;
        }
        int[] ret = new int[indices.length];
        if (offsets.length < shape.length) {
            int[] dup = new int[shape.length];
            System.arraycopy(offsets, 0, dup, 0, offsets.length);
            offsets = dup;
        }
        for (int i = 0; i < ret.length; ++i) {
            if (indices[i] instanceof NDArrayIndex.NDArrayIndexAll) {
                ret[i] = shape[i];
                continue;
            }
            int[] currIndices = indices[i].indices();
            if (currIndices.length < 1) continue;
            ret[i] = indices[i].indices().length;
            int n = i;
            ret[n] = ret[n] - offsets[i];
        }
        ArrayList<Integer> nonZeros = new ArrayList<Integer>();
        for (int i = 0; i < ret.length; ++i) {
            if (ret[i] <= 0) continue;
            nonZeros.add(ret[i]);
        }
        int[] ret2 = ArrayUtil.toArray(nonZeros);
        if (Shape.isRowVectorShape(ret2) && ret2.length == 1) {
            return new int[]{1, ret2[0]};
        }
        return ret2;
    }

    public static int[] shape(int[] shape, NDArrayIndex ... indices) {
        return Indices.shape(shape, new int[shape.length], indices);
    }
}

