/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.factory;

import com.google.common.base.Function;
import com.google.common.primitives.Ints;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.factory.DataBufferFactory;
import org.nd4j.linalg.api.buffer.factory.DefaultDataBufferFactory;
import org.nd4j.linalg.api.complex.IComplexDouble;
import org.nd4j.linalg.api.complex.IComplexFloat;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.instrumentation.InMemoryInstrumentation;
import org.nd4j.linalg.api.instrumentation.Instrumentation;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.executioner.DefaultOpExecutioner;
import org.nd4j.linalg.api.ops.executioner.OpExecutioner;
import org.nd4j.linalg.api.ops.factory.DefaultOpFactory;
import org.nd4j.linalg.api.ops.factory.OpFactory;
import org.nd4j.linalg.api.rng.DefaultRandom;
import org.nd4j.linalg.api.rng.Random;
import org.nd4j.linalg.api.rng.distribution.Distribution;
import org.nd4j.linalg.api.rng.distribution.factory.DefaultDistributionFactory;
import org.nd4j.linalg.api.rng.distribution.factory.DistributionFactory;
import org.nd4j.linalg.convolution.ConvolutionInstance;
import org.nd4j.linalg.convolution.DefaultConvolutionInstance;
import org.nd4j.linalg.factory.BlasWrapper;
import org.nd4j.linalg.factory.NDArrayFactory;
import org.nd4j.linalg.factory.Nd4jBackend;
import org.nd4j.linalg.fft.DefaultFFTInstance;
import org.nd4j.linalg.fft.FFTInstance;
import org.nd4j.linalg.indexing.BooleanIndexing;
import org.nd4j.linalg.indexing.conditions.Conditions;
import org.nd4j.linalg.indexing.functions.Value;
import org.nd4j.linalg.util.ArrayUtil;
import org.nd4j.linalg.util.Shape;
import org.springframework.core.io.Resource;

public class Nd4j {
    public static final String NUMERICAL_STABILITY = "force.stability";
    public static final String FFT_OPS = "fft";
    public static final String DATA_BUFFER_OPS = "databufferfactory";
    public static final String CONVOLUTION_OPS = "convops";
    public static final String DTYPE = "dtype";
    public static final String BLAS_OPS = "blas.ops";
    public static final String ORDER_KEY = "ndarray.order";
    public static final String NDARRAY_FACTORY_CLASS = "ndarrayfactory.class";
    public static final String COPY_OPS = "ndarray.copyops";
    public static final String OP_EXECUTIONER = "opexec";
    public static final String OP_FACTORY = "opfactory";
    public static final String RANDOM = "rng";
    public static final String DISTRIBUTION = "dist";
    public static final String INSTRUMENTATION = "instrumentation";
    public static final String RESOURCE_MANAGER = "resourcemanager";
    public static final String RESOURCE_MANGER_ON = "resourcemanager_state";
    public static final String ALLOC = "alloc";
    public static DataBuffer.Type dtype = DataBuffer.Type.FLOAT;
    public static DataBuffer.AllocationMode alloc = DataBuffer.AllocationMode.HEAP;
    public static char ORDER = (char)99;
    public static IComplexNumber UNIT;
    public static IComplexNumber ZERO;
    public static IComplexNumber NEG_UNIT;
    public static double EPS_THRESHOLD;
    public static int MAX_ELEMENTS_PER_SLICE;
    public static int MAX_SLICES_TO_PRINT;
    public static boolean ENFORCE_NUMERICAL_STABILITY;
    public static boolean copyOnOps;
    public static boolean shouldInstrument;
    public static boolean resourceManagerOn;
    protected static Class<? extends BlasWrapper> blasWrapperClazz;
    protected static Class<? extends NDArrayFactory> ndArrayFactoryClazz;
    protected static Class<? extends FFTInstance> fftInstanceClazz;
    protected static Class<? extends ConvolutionInstance> convolutionInstanceClazz;
    protected static Class<? extends DataBufferFactory> dataBufferFactoryClazz;
    protected static Class<? extends OpExecutioner> opExecutionerClazz;
    protected static Class<? extends OpFactory> opFactoryClazz;
    protected static Class<? extends Random> randomClazz;
    protected static Class<? extends DistributionFactory> distributionFactoryClazz;
    protected static Class<? extends Instrumentation> instrumentationClazz;
    protected static DataBufferFactory DATA_BUFFER_FACTORY_INSTANCE;
    protected static BlasWrapper BLAS_WRAPPER_INSTANCE;
    protected static NDArrayFactory INSTANCE;
    protected static FFTInstance FFT_INSTANCE;
    protected static ConvolutionInstance CONVOLUTION_INSTANCE;
    protected static OpExecutioner OP_EXECUTIONER_INSTANCE;
    protected static DistributionFactory DISTRIBUTION_FACTORY;
    protected static OpFactory OP_FACTORY_INSTANCE;
    protected static Random random;
    protected static Instrumentation instrumentation;
    protected static Properties props;
    protected static ReferenceQueue<INDArray> referenceQueue;
    protected static ReferenceQueue<DataBuffer> bufferQueue;

    public static ReferenceQueue<INDArray> refQueue() {
        return referenceQueue;
    }

    public static ReferenceQueue<DataBuffer> bufferRefQueue() {
        return bufferQueue;
    }

    public static Instrumentation getInstrumentation() {
        return instrumentation;
    }

    public static DistributionFactory getDistributions() {
        return DISTRIBUTION_FACTORY;
    }

    public static void setNdArrayFactoryClazz(Class<? extends NDArrayFactory> clazz) {
        ndArrayFactoryClazz = clazz;
    }

    public static synchronized Random getRandom() {
        if (random == null) {
            throw new IllegalStateException("Illegal random not found");
        }
        return random;
    }

    public static ConvolutionInstance getConvolution() {
        return CONVOLUTION_INSTANCE;
    }

    public static void setConvolution(ConvolutionInstance convolutionInstance) {
        if (convolutionInstance == null) {
            throw new IllegalArgumentException("No null instances allowed");
        }
        CONVOLUTION_INSTANCE = convolutionInstance;
    }

    public static int[] shape(INDArray arr) {
        return arr.shape();
    }

    public static INDArray create(int[] sliceShape, float[] ... arrays) {
        int slices = arrays.length;
        INDArray ret = Nd4j.create(ArrayUtil.combine({slices}, sliceShape));
        for (int i = 0; i < ret.slices(); ++i) {
            ret.putSlice(i, Nd4j.create(arrays[i]).reshape(sliceShape));
        }
        return ret;
    }

    public static INDArray create(int[] sliceShape, double[] ... arrays) {
        int slices = arrays.length;
        INDArray ret = Nd4j.create(ArrayUtil.combine({slices}, sliceShape));
        for (int i = 0; i < ret.slices(); ++i) {
            ret.putSlice(i, Nd4j.create(arrays[i]).reshape(sliceShape));
        }
        return ret;
    }

    public static OpExecutioner getExecutioner() {
        return OP_EXECUTIONER_INSTANCE;
    }

    public static OpFactory getOpFactory() {
        return OP_FACTORY_INSTANCE;
    }

    public static FFTInstance getFFt() {
        return FFT_INSTANCE;
    }

    public static void setFft(FFTInstance fftInstance) {
        if (fftInstance == null) {
            throw new IllegalArgumentException("No null instances allowed");
        }
        FFT_INSTANCE = fftInstance;
    }

    public static void setParams(INDArray theta, Collection<INDArray> ... matrices) {
        int index = 0;
        for (Collection<INDArray> matrixCollection : matrices) {
            for (INDArray matrix : matrixCollection) {
                INDArray linear = matrix.linearView();
                for (int i = 0; i < matrix.length(); ++i) {
                    linear.putScalar(i, theta.getDouble(index));
                    ++index;
                }
            }
        }
        if (index != theta.length()) {
            throw new AssertionError((Object)"Did not entirely use the theta vector");
        }
    }

    public static void setParams(INDArray theta, Iterator<? extends INDArray> ... matrices) {
        int index = 0;
        for (Iterator<? extends INDArray> matrixIterator : matrices) {
            while (matrixIterator.hasNext()) {
                INDArray matrix = matrixIterator.next().linearView();
                for (int i = 0; i < matrix.length(); ++i) {
                    matrix.putScalar(i, theta.getDouble(index));
                    ++index;
                }
            }
        }
        if (index != theta.length()) {
            throw new AssertionError((Object)"Did not entirely use the theta vector");
        }
    }

    private static void logCreationIfNecessary(DataBuffer log) {
        if (shouldInstrument) {
            Nd4j.getInstrumentation().log(log);
        }
    }

    private static void logCreationIfNecessary(INDArray log) {
        if (shouldInstrument) {
            Nd4j.getInstrumentation().log(log);
        }
    }

    public static NDArrayFactory factory() {
        return INSTANCE;
    }

    public static INDArray cumsum(INDArray compute) {
        return compute.cumsum(Integer.MAX_VALUE);
    }

    public static INDArray max(INDArray compute) {
        return compute.max(Integer.MAX_VALUE);
    }

    public static INDArray min(INDArray compute) {
        return compute.min(Integer.MAX_VALUE);
    }

    public static INDArray prod(INDArray compute) {
        return compute.prod(Integer.MAX_VALUE);
    }

    public static INDArray normmax(INDArray compute) {
        return compute.normmax(Integer.MAX_VALUE);
    }

    public static INDArray norm2(INDArray compute) {
        return compute.norm2(Integer.MAX_VALUE);
    }

    public static INDArray norm1(INDArray compute) {
        return compute.norm1(Integer.MAX_VALUE);
    }

    public static INDArray std(INDArray compute) {
        return compute.std(Integer.MAX_VALUE);
    }

    public static INDArray var(INDArray compute) {
        return compute.var(Integer.MAX_VALUE);
    }

    public static INDArray sum(INDArray compute) {
        return compute.sum(Integer.MAX_VALUE);
    }

    public static INDArray mean(INDArray compute) {
        return compute.mean(Integer.MAX_VALUE);
    }

    public static IComplexNDArray cumsum(IComplexNDArray compute) {
        return compute.cumsum(Integer.MAX_VALUE);
    }

    public static IComplexNDArray max(IComplexNDArray compute) {
        return compute.max(Integer.MAX_VALUE);
    }

    public static IComplexNDArray min(IComplexNDArray compute) {
        return compute.min(Integer.MAX_VALUE);
    }

    public static IComplexNDArray prod(IComplexNDArray compute) {
        return compute.prod(Integer.MAX_VALUE);
    }

    public static IComplexNDArray normmax(IComplexNDArray compute) {
        return compute.normmax(Integer.MAX_VALUE);
    }

    public static IComplexNDArray norm2(IComplexNDArray compute) {
        return compute.norm2(Integer.MAX_VALUE);
    }

    public static IComplexNDArray norm1(IComplexNDArray compute) {
        return compute.norm1(Integer.MAX_VALUE);
    }

    public static IComplexNDArray std(IComplexNDArray compute) {
        return compute.std(Integer.MAX_VALUE);
    }

    public static IComplexNDArray var(IComplexNDArray compute) {
        return compute.var(Integer.MAX_VALUE);
    }

    public static IComplexNDArray sum(IComplexNDArray compute) {
        return compute.sum(Integer.MAX_VALUE);
    }

    public static IComplexNDArray mean(IComplexNDArray compute) {
        return compute.mean(Integer.MAX_VALUE);
    }

    public static INDArray cumsum(INDArray compute, int dimension) {
        return compute.cumsum(dimension);
    }

    public static INDArray max(INDArray compute, int dimension) {
        return compute.max(dimension);
    }

    public static INDArray min(INDArray compute, int dimension) {
        return compute.min(dimension);
    }

    public static INDArray prod(INDArray compute, int dimension) {
        return compute.prod(dimension);
    }

    public static INDArray normmax(INDArray compute, int dimension) {
        return compute.normmax(dimension);
    }

    public static INDArray norm2(INDArray compute, int dimension) {
        return compute.norm2(dimension);
    }

    public static INDArray norm1(INDArray compute, int dimension) {
        return compute.norm1(dimension);
    }

    public static INDArray std(INDArray compute, int dimension) {
        return compute.std(dimension);
    }

    public static INDArray var(INDArray compute, int dimension) {
        return compute.var(dimension);
    }

    public static INDArray sum(INDArray compute, int dimension) {
        return compute.sum(dimension);
    }

    public static INDArray mean(INDArray compute, int dimension) {
        return compute.mean(dimension);
    }

    public static IComplexNDArray cumsum(IComplexNDArray compute, int dimension) {
        return compute.cumsum(dimension);
    }

    public static IComplexNDArray max(IComplexNDArray compute, int dimension) {
        return compute.max(dimension);
    }

    public static IComplexNDArray min(IComplexNDArray compute, int dimension) {
        return compute.min(dimension);
    }

    public static IComplexNDArray prod(IComplexNDArray compute, int dimension) {
        return compute.prod(dimension);
    }

    public static IComplexNDArray normmax(IComplexNDArray compute, int dimension) {
        return compute.normmax(dimension);
    }

    public static IComplexNDArray norm2(IComplexNDArray compute, int dimension) {
        return compute.norm2(dimension);
    }

    public static IComplexNDArray norm1(IComplexNDArray compute, int dimension) {
        return compute.norm1(dimension);
    }

    public static IComplexNDArray std(IComplexNDArray compute, int dimension) {
        return compute.std(dimension);
    }

    public static IComplexNDArray var(IComplexNDArray compute, int dimension) {
        return compute.var(dimension);
    }

    public static IComplexNDArray sum(IComplexNDArray compute, int dimension) {
        return compute.sum(dimension);
    }

    public static IComplexNDArray mean(IComplexNDArray compute, int dimension) {
        return compute.mean(dimension);
    }

    public static DataBuffer createBuffer(int[] shape, DataBuffer.Type type) {
        int length = ArrayUtil.prod(shape);
        return type == DataBuffer.Type.DOUBLE ? Nd4j.createBuffer(new double[length]) : Nd4j.createBuffer(new float[length]);
    }

    public static DataBuffer createBuffer(int[] shape) {
        int length = ArrayUtil.prod(shape);
        return Nd4j.createBuffer(length);
    }

    public static DataBuffer createBuffer(int length) {
        DataBuffer ret = Nd4j.dataType() == DataBuffer.Type.FLOAT ? DATA_BUFFER_FACTORY_INSTANCE.createFloat(length) : DATA_BUFFER_FACTORY_INSTANCE.createDouble(length);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static DataBuffer createBuffer(float[] data) {
        DataBuffer ret = Nd4j.dataType() == DataBuffer.Type.FLOAT ? DATA_BUFFER_FACTORY_INSTANCE.createFloat(data) : DATA_BUFFER_FACTORY_INSTANCE.createDouble(ArrayUtil.toDoubles(data));
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static DataBuffer createBuffer(double[] data) {
        DataBuffer ret = Nd4j.dataType() == DataBuffer.Type.DOUBLE ? DATA_BUFFER_FACTORY_INSTANCE.createDouble(data) : DATA_BUFFER_FACTORY_INSTANCE.createFloat(ArrayUtil.toFloats(data));
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static void setFactory(NDArrayFactory factory) {
        INSTANCE = factory;
    }

    public static Character order() {
        return Character.valueOf(Nd4j.factory().order());
    }

    public static DataBuffer.Type dataType() {
        return dtype;
    }

    public static BlasWrapper getBlasWrapper() {
        return BLAS_WRAPPER_INSTANCE;
    }

    public static void setBlasWrapper(BlasWrapper factory) {
        BLAS_WRAPPER_INSTANCE = factory;
    }

    public static IComplexNDArray createComplex(INDArray real, INDArray imag) {
        assert (Shape.shapeEquals(real.shape(), imag.shape()));
        IComplexNDArray ret = Nd4j.createComplex(real.shape());
        INDArray realLinear = real.linearView();
        INDArray imagLinear = imag.linearView();
        IComplexNDArray retLinear = ret.linearView();
        for (int i = 0; i < ret.length(); ++i) {
            retLinear.putScalar(i, Nd4j.createComplexNumber(realLinear.getDouble(i), imagLinear.getDouble(i)));
        }
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray repeat(IComplexNDArray n, int num) {
        ArrayList<IComplexNDArray> list = new ArrayList<IComplexNDArray>();
        for (int i = 0; i < num; ++i) {
            list.add(n.dup());
        }
        IComplexNDArray ret = Nd4j.createComplex(list, Ints.concat((int[][])new int[][]{{num}, n.shape()}));
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray[] sortWithIndices(IComplexNDArray ndarray, int dimension, boolean ascending) {
        INDArray indices = Nd4j.create(ndarray.shape());
        INDArray[] ret = new INDArray[2];
        for (int i = 0; i < ndarray.vectorsAlongDimension(dimension); ++i) {
            int j;
            IComplexNDArray vec = ndarray.vectorAlongDimension(i, dimension);
            INDArray indexVector = indices.vectorAlongDimension(i, dimension);
            final IComplexNumber[] data = new IComplexNumber[vec.length()];
            Double[] index = new Double[vec.length()];
            for (j = 0; j < vec.length(); ++j) {
                data[j] = vec.getComplex(j);
                index[j] = j;
            }
            if (ascending) {
                Arrays.sort(index, new Comparator<Double>(){

                    @Override
                    public int compare(Double o1, Double o2) {
                        int idx1 = (int)o1.doubleValue();
                        int idx2 = (int)o2.doubleValue();
                        return Double.compare(data[idx1].absoluteValue().doubleValue(), data[idx2].absoluteValue().doubleValue());
                    }
                });
            } else {
                Arrays.sort(index, new Comparator<Double>(){

                    @Override
                    public int compare(Double o1, Double o2) {
                        int idx1 = (int)o1.doubleValue();
                        int idx2 = (int)o2.doubleValue();
                        return -Double.compare(data[idx1].absoluteValue().doubleValue(), data[idx2].absoluteValue().doubleValue());
                    }
                });
            }
            for (j = 0; j < vec.length(); ++j) {
                vec.putScalar(j, data[(int)index[j].doubleValue()]);
                indexVector.putScalar(j, (double)index[j]);
            }
        }
        ret[0] = indices;
        ret[1] = ndarray;
        return ret;
    }

    public static INDArray[] sortWithIndices(INDArray ndarray, int dimension, boolean ascending) {
        INDArray indices = Nd4j.create(ndarray.shape());
        INDArray[] ret = new INDArray[2];
        for (int i = 0; i < ndarray.vectorsAlongDimension(dimension); ++i) {
            int j;
            INDArray vec = ndarray.vectorAlongDimension(i, dimension);
            INDArray indexVector = indices.vectorAlongDimension(i, dimension);
            final Double[] data = new Double[vec.length()];
            Double[] index = new Double[vec.length()];
            for (j = 0; j < vec.length(); ++j) {
                data[j] = vec.getDouble(j);
                index[j] = j;
            }
            Arrays.sort(index, new Comparator<Double>(){

                @Override
                public int compare(Double o1, Double o2) {
                    int o = (int)o1.doubleValue();
                    int oo2 = (int)o2.doubleValue();
                    return Double.compare(data[o], data[oo2]);
                }
            });
            if (ascending) {
                for (j = 0; j < vec.length(); ++j) {
                    vec.putScalar(j, (double)data[(int)index[j].doubleValue()]);
                    indexVector.putScalar(j, (double)index[j]);
                }
                continue;
            }
            int count = data.length - 1;
            for (int j2 = 0; j2 < vec.length(); ++j2) {
                int currCount2 = count--;
                vec.putScalar(j2, (double)data[(int)index[currCount2].doubleValue()]);
                indexVector.putScalar(j2, (double)index[currCount2]);
            }
        }
        ret[0] = indices;
        ret[1] = ndarray;
        return ret;
    }

    public static IComplexNDArray sort(IComplexNDArray ndarray, int dimension, boolean ascending) {
        for (int i = 0; i < ndarray.vectorsAlongDimension(dimension); ++i) {
            int j;
            IComplexNDArray vec = ndarray.vectorAlongDimension(i, dimension);
            IComplexNumber[] data = new IComplexNumber[vec.length()];
            for (j = 0; j < vec.length(); ++j) {
                data[j] = vec.getComplex(j);
            }
            if (ascending) {
                Arrays.sort(data, new Comparator<IComplexNumber>(){

                    @Override
                    public int compare(IComplexNumber o1, IComplexNumber o2) {
                        return Double.compare(o1.asDouble().absoluteValue().doubleValue(), o2.asDouble().absoluteValue().doubleValue());
                    }
                });
            } else {
                Arrays.sort(data, new Comparator<IComplexNumber>(){

                    @Override
                    public int compare(IComplexNumber o1, IComplexNumber o2) {
                        return -Double.compare(o1.asDouble().absoluteValue().doubleValue(), o2.asDouble().absoluteValue().doubleValue());
                    }
                });
            }
            for (j = 0; j < vec.length(); ++j) {
                vec.putScalar(j, data[j]);
            }
        }
        return ndarray;
    }

    public static INDArray sort(INDArray ndarray, int dimension, boolean ascending) {
        for (int i = 0; i < ndarray.vectorsAlongDimension(dimension); ++i) {
            int j;
            INDArray vec = ndarray.vectorAlongDimension(i, dimension);
            double[] data = new double[vec.length()];
            for (j = 0; j < vec.length(); ++j) {
                data[j] = vec.getDouble(j);
            }
            Arrays.sort(data);
            if (ascending) {
                for (j = 0; j < vec.length(); ++j) {
                    vec.putScalar(j, data[j]);
                }
                continue;
            }
            int count = data.length - 1;
            for (int j2 = 0; j2 < vec.length(); ++j2) {
                vec.putScalar(j2, data[count--]);
            }
        }
        return ndarray;
    }

    public static INDArray repeat(INDArray n, int num) {
        int[] nArray;
        ArrayList<INDArray> list = new ArrayList<INDArray>();
        for (int i = 0; i < num; ++i) {
            list.add(n.dup());
        }
        if (n.isColumnVector()) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = n.shape()[0];
        } else {
            nArray = n.shape();
        }
        int[] shape = nArray;
        int[] retShape = Ints.concat((int[][])new int[][]{{num}, shape});
        return Nd4j.create(list, retShape);
    }

    public static INDArray linspace(int lower, int upper, int num) {
        return INSTANCE.linspace(lower, upper, num);
    }

    public static INDArray toFlattened(Collection<INDArray> matrices) {
        INDArray ret = INSTANCE.toFlattened(matrices);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray complexFlatten(List<IComplexNDArray> flatten) {
        IComplexNDArray ret = INSTANCE.complexFlatten(flatten);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray complexFlatten(IComplexNDArray ... flatten) {
        IComplexNDArray ret = INSTANCE.complexFlatten(flatten);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray toFlattened(int length, Iterator<? extends INDArray> ... matrices) {
        INDArray ret = INSTANCE.toFlattened(length, matrices);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray bilinearProducts(INDArray curr, INDArray in) {
        return INSTANCE.bilinearProducts(curr, in);
    }

    public static INDArray toFlattened(INDArray ... matrices) {
        return INSTANCE.toFlattened(matrices);
    }

    public static INDArray eye(int n) {
        INDArray ret = INSTANCE.eye(n);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static void rot90(INDArray toRotate) {
        INSTANCE.rot90(toRotate);
    }

    public static void writeTxt(INDArray write, String filePath, String split) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(filePath));
        for (int i = 0; i < write.rows(); ++i) {
            StringBuffer sb = new StringBuffer();
            INDArray row = write.getRow(i);
            for (int j = 0; j < row.columns(); ++j) {
                sb.append(row.getDouble(j));
                sb.append(split);
            }
            sb.append("\n");
            writer.write(sb.toString());
        }
        writer.flush();
        writer.close();
    }

    public static INDArray readTxt(InputStream filePath, String split) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(filePath));
        ArrayList<float[]> data2 = new ArrayList<float[]>();
        int numColumns = -1;
        while ((line = reader.readLine()) != null) {
            String[] data = line.trim().split(split);
            if (numColumns < 0) {
                numColumns = data.length;
            } else assert (data.length == numColumns) : "Data has inconsistent number of columns";
            data2.add(Nd4j.read(data));
        }
        INDArray ret = Nd4j.create(data2.size(), numColumns);
        for (int i = 0; i < data2.size(); ++i) {
            ret.putRow(i, Nd4j.create(Nd4j.createBuffer((float[])data2.get(i))));
        }
        return ret;
    }

    private static float[] read(String[] split) {
        float[] ret = new float[split.length];
        for (int i = 0; i < split.length; ++i) {
            ret[i] = Float.parseFloat(split[i]);
        }
        return ret;
    }

    public static INDArray readTxt(String filePath, String split) throws IOException {
        return Nd4j.readTxt(new FileInputStream(filePath), split);
    }

    public static INDArray readTxt(String filePath) throws IOException {
        return Nd4j.readTxt(filePath, "\t");
    }

    private static INDArray loadRow(String[] data) {
        INDArray ret = Nd4j.create(data.length);
        for (int i = 0; i < data.length; ++i) {
            ret.putScalar(i, Double.parseDouble(data[i]));
        }
        return ret;
    }

    public static INDArray read(DataInputStream dis) throws IOException {
        int i;
        int dimensions = dis.readInt();
        int[] shape = new int[dimensions];
        int[] stride = new int[dimensions];
        for (i = 0; i < dimensions; ++i) {
            shape[i] = dis.readInt();
        }
        for (i = 0; i < dimensions; ++i) {
            stride[i] = dis.readInt();
        }
        String dataType = dis.readUTF();
        String type = dis.readUTF();
        if (!type.equals("real")) {
            throw new IllegalArgumentException("Trying to read in a complex ndarray");
        }
        if (dataType.equals("double")) {
            double[] data = ArrayUtil.readDouble(ArrayUtil.prod(shape), dis);
            return Nd4j.create(data, shape, stride, 0);
        }
        float[] data = ArrayUtil.readFloat(ArrayUtil.prod(shape), dis);
        return Nd4j.create(data, shape, stride, 0);
    }

    public static void write(INDArray arr, DataOutputStream dataOutputStream) throws IOException {
        int i;
        dataOutputStream.writeInt(arr.shape().length);
        for (i = 0; i < arr.shape().length; ++i) {
            dataOutputStream.writeInt(arr.size(i));
        }
        for (i = 0; i < arr.stride().length; ++i) {
            dataOutputStream.writeInt(arr.stride()[i]);
        }
        dataOutputStream.writeUTF(Nd4j.dataType() == DataBuffer.Type.FLOAT ? "float" : "double");
        dataOutputStream.writeUTF("real");
        if (Nd4j.dataType() == DataBuffer.Type.DOUBLE) {
            ArrayUtil.write(arr.data().asDouble(), dataOutputStream);
        } else {
            ArrayUtil.write(arr.data().asFloat(), dataOutputStream);
        }
    }

    public static void clearNans(INDArray arr) {
        BooleanIndexing.applyWhere(arr, Conditions.isNan(), new Value(EPS_THRESHOLD));
    }

    public static INDArray create(double[][] data) {
        return INSTANCE.create(data);
    }

    public static IComplexNDArray readComplex(DataInputStream dis) throws IOException {
        int i;
        int dimensions = dis.readInt();
        int[] shape = new int[dimensions];
        int[] stride = new int[dimensions];
        for (i = 0; i < dimensions; ++i) {
            shape[i] = dis.readInt();
        }
        for (i = 0; i < dimensions; ++i) {
            stride[i] = dis.readInt();
        }
        String dataType = dis.readUTF();
        String type = dis.readUTF();
        if (!type.equals("complex")) {
            throw new IllegalArgumentException("Trying to read in a real ndarray");
        }
        if (dataType.equals("double")) {
            double[] data = ArrayUtil.readDouble(ArrayUtil.prod(shape), dis);
            return Nd4j.createComplex(data, shape, stride, 0);
        }
        double[] data = ArrayUtil.read(ArrayUtil.prod(shape), dis);
        return Nd4j.createComplex(data, shape, stride, 0);
    }

    public static void writeComplex(IComplexNDArray arr, DataOutputStream dataOutputStream) throws IOException {
        int i;
        dataOutputStream.writeInt(arr.shape().length);
        for (i = 0; i < arr.shape().length; ++i) {
            dataOutputStream.writeInt(arr.size(i));
        }
        for (i = 0; i < arr.stride().length; ++i) {
            dataOutputStream.writeInt(arr.stride()[i]);
        }
        dataOutputStream.writeUTF(Nd4j.dataType() == DataBuffer.Type.FLOAT ? "float" : "double");
        dataOutputStream.writeUTF("complex");
        if (Nd4j.dataType() == DataBuffer.Type.DOUBLE) {
            ArrayUtil.write(arr.data().asDouble(), dataOutputStream);
        } else {
            ArrayUtil.write(arr.data().asFloat(), dataOutputStream);
        }
    }

    public static INDArray rot(INDArray reverse) {
        INDArray ret = INSTANCE.rot(reverse);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray reverse(INDArray reverse) {
        INDArray ret = INSTANCE.reverse(reverse);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray arange(double begin, double end) {
        INDArray ret = INSTANCE.arange(begin, end);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNumber createComplexNumber(Number real, Number imag) {
        if (Nd4j.dataType() == DataBuffer.Type.FLOAT) {
            return INSTANCE.createFloat(real.floatValue(), imag.floatValue());
        }
        return INSTANCE.createDouble(real.doubleValue(), imag.doubleValue());
    }

    public static IComplexFloat createFloat(float real, float imag) {
        return INSTANCE.createFloat(real, imag);
    }

    public static IComplexDouble createDouble(double real, double imag) {
        return INSTANCE.createDouble(real, imag);
    }

    public static void copy(INDArray a, INDArray b) {
        INSTANCE.copy(a, b);
    }

    public static INDArray rand(int[] shape, double min, double max, Random rng) {
        INDArray ret = INSTANCE.rand(shape, min, max, rng);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray rand(int rows, int columns, double min, double max, Random rng) {
        if (min > max) {
            throw new IllegalArgumentException("the maximum value supplied is smaller than the minimum");
        }
        INDArray ret = INSTANCE.rand(rows, columns, min, max, rng);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray diag(IComplexNDArray x, int k) {
        if (x.isScalar()) {
            return x.dup();
        }
        if (x.isVector()) {
            IComplexNDArray m = Nd4j.createComplex(x.length(), x.length());
            IComplexNDArray xLinear = x.linearView();
            for (int i = 0; i < x.length(); ++i) {
                m.putScalar(i, i, xLinear.getComplex(i));
            }
            return m;
        }
        if (x.isMatrix()) {
            int vectorLength = x.rows() - k;
            IComplexNDArray ret = Nd4j.createComplex(new int[]{vectorLength, 1});
            for (int i = 0; i < vectorLength; ++i) {
                ret.putScalar(i, x.getComplex(i, i));
            }
            return ret;
        }
        throw new IllegalArgumentException("Illegal input for diagonal of shape " + x.shape().length);
    }

    public static INDArray diag(INDArray x, int k) {
        if (x.isScalar()) {
            return x.dup();
        }
        if (x.isVector()) {
            INDArray m = Nd4j.create(x.length(), x.length());
            INDArray xLinear = x.linearView();
            for (int i = 0; i < x.length(); ++i) {
                m.put(i, i, xLinear.getDouble(i));
            }
            return m;
        }
        if (x.isMatrix()) {
            int vectorLength = x.rows() - k;
            INDArray ret = Nd4j.create(new int[]{vectorLength, 1});
            for (int i = 0; i < vectorLength; ++i) {
                ret.putScalar(i, x.getDouble(i, i));
            }
            return ret;
        }
        throw new IllegalArgumentException("Illegal input for diagonal of shape " + x.shape().length);
    }

    public static IComplexNDArray diag(IComplexNDArray x) {
        return Nd4j.diag(x, 0);
    }

    public static INDArray diag(INDArray x) {
        return Nd4j.diag(x, 0);
    }

    public static INDArray appendBias(INDArray ... vectors) {
        INDArray ret = INSTANCE.appendBias(vectors);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static void doAlongDiagonal(INDArray x, Function<Number, Number> func) {
        if (x.isMatrix()) {
            for (int i = 0; i < x.rows(); ++i) {
                x.put(i, i, (Number)func.apply((Object)x.getDouble(i, i)));
            }
        }
    }

    public static void doAlongDiagonal(IComplexNDArray x, Function<IComplexNumber, IComplexNumber> func) {
        if (x.isMatrix()) {
            for (int i = 0; i < x.rows(); ++i) {
                x.putScalar(i, i, (IComplexNumber)func.apply((Object)x.getComplex(i, i)));
            }
        }
    }

    public static IComplexNDArray createComplex(INDArray arr) {
        if (arr instanceof IComplexNDArray) {
            return (IComplexNDArray)arr;
        }
        IComplexNDArray ret = INSTANCE.createComplex(arr);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(IComplexNumber[] data, int[] shape) {
        IComplexNDArray ret = INSTANCE.createComplex(data, shape);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(IComplexNumber[] data, int[] shape, int offset, char ordering) {
        IComplexNDArray ret = INSTANCE.createComplex(data, shape, offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(List<IComplexNDArray> arrs, int[] shape) {
        IComplexNDArray ret = INSTANCE.createComplex(arrs, shape);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    @Deprecated
    public static INDArray rand(int rows, int columns, Random r) {
        INDArray ret = INSTANCE.rand(rows, columns, r);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray rand(long seed, int ... shape) {
        INDArray ret = INSTANCE.rand(shape, seed);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray rand(int rows, int columns, long seed) {
        INDArray ret = INSTANCE.rand(rows, columns, seed);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray rand(int rows, int columns) {
        INDArray ret = INSTANCE.rand(rows, columns);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray randn(int rows, int columns, Random r) {
        INDArray ret = INSTANCE.randn(rows, columns, r);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray randn(int rows, int columns) {
        INDArray ret = INSTANCE.randn(rows, columns);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray randn(int rows, int columns, long seed) {
        INDArray ret = INSTANCE.randn(rows, columns, seed);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray rand(int[] shape, Distribution r) {
        INDArray ret = INSTANCE.rand(shape, r);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray rand(int[] shape, Random r) {
        INDArray ret = INSTANCE.rand(shape, r);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray rand(int[] shape, long seed) {
        INDArray ret = INSTANCE.rand(shape, seed);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray rand(int[] shape) {
        INDArray ret = INSTANCE.rand(shape);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray randn(int[] shape, Random r) {
        INDArray ret = INSTANCE.randn(shape, r);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray randn(int[] shape) {
        INDArray ret = INSTANCE.randn(shape);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray randn(int[] shape, long seed) {
        Nd4j.getRandom().setSeed(seed);
        return Nd4j.randn(shape, Nd4j.getRandom());
    }

    public static INDArray create(float[] data, char order) {
        INDArray ret = INSTANCE.create(data, order);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(double[] data, char order) {
        INDArray ret = INSTANCE.create(data, order);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(double[] data, char order) {
        IComplexNDArray ret = INSTANCE.createComplex(data);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(int columns, char order) {
        INDArray ret = INSTANCE.create(new int[]{1, columns}, Nd4j.getStrides(new int[]{1, columns}, order));
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(int columns, char order) {
        IComplexNDArray ret = INSTANCE.createComplex(columns);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(float[] data) {
        return Nd4j.create(data, Nd4j.order().charValue());
    }

    public static INDArray create(double[] data) {
        return Nd4j.create(data, Nd4j.order().charValue());
    }

    public static IComplexNDArray createComplex(float[] data) {
        return Nd4j.createComplex(data, Nd4j.order());
    }

    private static IComplexNDArray createComplex(float[] data, Character order) {
        IComplexNDArray ret = INSTANCE.createComplex(data, order);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(int columns) {
        return Nd4j.create(columns, Nd4j.order().charValue());
    }

    public static IComplexNDArray createComplex(int columns) {
        return Nd4j.createComplex(columns, Nd4j.order().charValue());
    }

    public static boolean hasInvalidNumber(INDArray num) {
        INDArray linear = num.linearView();
        for (int i = 0; i < linear.length(); ++i) {
            if (!Double.isInfinite(linear.getDouble(i)) && !Double.isNaN(linear.getDouble(i))) continue;
            return true;
        }
        return false;
    }

    public static INDArray zeros(int rows, int columns) {
        INDArray ret = INSTANCE.zeros(rows, columns);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray complexZeros(int rows, int columns) {
        IComplexNDArray ret = INSTANCE.complexZeros(rows, columns);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray zeros(int columns) {
        return INSTANCE.zeros(columns);
    }

    public static IComplexNDArray complexZeros(int columns) {
        return INSTANCE.complexZeros(columns);
    }

    public static IComplexNDArray complexValueOf(int num, IComplexNumber value) {
        IComplexNDArray ret = INSTANCE.complexValueOf(num, value);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray complexValueOf(int[] shape, IComplexNumber value) {
        IComplexNDArray ret = INSTANCE.complexValueOf(shape, value);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray complexValueOf(int num, double value) {
        return INSTANCE.complexValueOf(num, value);
    }

    public static IComplexNDArray complexValueOf(int[] shape, double value) {
        IComplexNDArray ret = INSTANCE.complexValueOf(shape, value);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray valueArrayOf(int[] shape, double value) {
        INDArray ret = INSTANCE.valueArrayOf(shape, value);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray valueArrayOf(int num, double value) {
        INDArray ret = INSTANCE.valueArrayOf(new int[]{1, num}, value);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray valueArrayOf(int rows, int columns, double value) {
        INDArray ret = INSTANCE.valueArrayOf(rows, columns, value);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray ones(int rows, int columns) {
        INDArray ret = INSTANCE.ones(rows, columns);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray zerosLike(INDArray arr) {
        return Nd4j.create(arr.shape());
    }

    public static INDArray emptyLike(INDArray arr) {
        return Nd4j.create(arr.shape());
    }

    public static INDArray onesLike(INDArray arr) {
        return Nd4j.ones(arr.shape());
    }

    public static IComplexNDArray complexOnes(int rows, int columns) {
        IComplexNDArray ret = INSTANCE.complexOnes(rows, columns);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray ones(int columns) {
        INDArray ret = INSTANCE.ones(columns);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray complexOnes(int columns) {
        IComplexNDArray ret = INSTANCE.complexOnes(columns);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray hstack(INDArray ... arrs) {
        INDArray ret = INSTANCE.hstack(arrs);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray vstack(INDArray ... arrs) {
        INDArray ret = INSTANCE.vstack(arrs);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray concat(int dimension, INDArray ... toConcat) {
        INDArray ret = INSTANCE.concat(dimension, toConcat);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray concat(int dimension, IComplexNDArray ... toConcat) {
        IComplexNDArray ret = INSTANCE.concat(dimension, toConcat);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray zeros(int[] shape) {
        INDArray ret = INSTANCE.zeros(shape);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray complexZeros(int ... shape) {
        IComplexNDArray ret = INSTANCE.complexZeros(shape);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray ones(int ... shape) {
        INDArray ret = INSTANCE.ones(shape);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray complexOnes(int[] shape) {
        IComplexNDArray ret = INSTANCE.complexOnes(shape);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(float[] data, int rows, int columns, int[] stride, int offset) {
        IComplexNDArray ret = INSTANCE.createComplex(data, rows, columns, stride, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(float[] data, int rows, int columns, int[] stride, int offset) {
        INDArray ret = INSTANCE.create(data, rows, columns, stride, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(double[] data, int[] shape, int[] stride, int offset) {
        IComplexNDArray ret = INSTANCE.createComplex(data, shape, stride, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(double[] data, int[] shape, int[] stride, int offset) {
        INDArray ret = INSTANCE.create(data, shape, stride, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(double[] data, int[] shape) {
        INDArray ret = INSTANCE.create(data, shape);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(float[] data, int[] shape) {
        INDArray ret = INSTANCE.create(data, shape);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(float[] data, int[] shape) {
        IComplexNDArray ret = INSTANCE.createComplex(data, shape);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(double[] data, int[] shape) {
        IComplexNDArray ret = INSTANCE.createComplex(data, shape);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(float[] data, int[] shape, int[] stride) {
        IComplexNDArray ret = INSTANCE.createComplex(data, shape, stride);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(double[] data, int[] shape, int[] stride) {
        IComplexNDArray ret = INSTANCE.createComplex(data, shape, stride);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(double[] data, int rows, int columns, int[] stride, int offset) {
        IComplexNDArray ret = INSTANCE.createComplex(data, rows, columns, stride, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(double[] data, int rows, int columns, int[] stride, int offset) {
        INDArray ret = INSTANCE.create(data, rows, columns, stride, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(float[] data, int[] shape, int[] stride, int offset) {
        IComplexNDArray ret = INSTANCE.createComplex(data, shape, stride, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(float[] data, int[] shape, int offset) {
        INDArray ret = INSTANCE.create(data, shape, offset, Nd4j.order());
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(double[] data, int[] shape, int offset, char ordering) {
        INDArray ret = INSTANCE.create(data, shape, Nd4j.getStrides(shape), offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(float[] data, int[] shape, int[] stride, int offset) {
        INDArray ret = INSTANCE.create(data, shape, stride, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(List<INDArray> list, int[] shape) {
        INDArray ret = INSTANCE.create(list, shape);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(int rows, int columns, int[] stride, int offset) {
        IComplexNDArray ret = INSTANCE.createComplex(rows, columns, stride, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(int rows, int columns, int[] stride, int offset) {
        INDArray ret = INSTANCE.create(rows, columns, stride, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(int[] shape, int[] stride, int offset) {
        IComplexNDArray ret = INSTANCE.createComplex(shape, stride, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(int[] shape, int[] stride, int offset) {
        INDArray ret = INSTANCE.create(shape, stride, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(int rows, int columns, int[] stride) {
        return Nd4j.createComplex(rows, columns, stride, Nd4j.order().charValue());
    }

    public static INDArray create(int rows, int columns, int[] stride) {
        return Nd4j.create(rows, columns, stride, Nd4j.order().charValue());
    }

    public static IComplexNDArray createComplex(int[] shape, int[] stride) {
        return Nd4j.createComplex(shape, stride, Nd4j.order().charValue());
    }

    public static INDArray create(int[] shape, int[] stride) {
        return Nd4j.create(shape, stride, Nd4j.order().charValue());
    }

    public static IComplexNDArray createComplex(int rows, int columns) {
        return Nd4j.createComplex(rows, columns, Nd4j.order().charValue());
    }

    public static INDArray create(int rows, int columns) {
        return Nd4j.create(rows, columns, Nd4j.order().charValue());
    }

    public static IComplexNDArray createComplex(int ... shape) {
        return Nd4j.createComplex(shape, Nd4j.order().charValue());
    }

    public static INDArray create(int ... shape) {
        return Nd4j.create(shape, Nd4j.order().charValue());
    }

    public static INDArray scalar(Number value, int offset) {
        return INSTANCE.scalar(value, offset);
    }

    public static IComplexNDArray complexScalar(Number value, int offset) {
        IComplexNDArray arr = INSTANCE.complexScalar(value, offset);
        Nd4j.logCreationIfNecessary(arr);
        return arr;
    }

    public static IComplexNDArray complexScalar(Number value) {
        return INSTANCE.complexScalar(value);
    }

    public static INDArray scalar(double value, int offset) {
        INDArray ret = INSTANCE.scalar(value, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray scalar(float value, int offset) {
        INDArray ret = INSTANCE.scalar(value, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray scalar(Number value) {
        INDArray ret = INSTANCE.scalar(value);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray scalar(double value) {
        INDArray ret = INSTANCE.scalar(value);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray scalar(float value) {
        INDArray ret = INSTANCE.scalar(value);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray scalar(IComplexNumber value, int offset) {
        IComplexNDArray ret = INSTANCE.scalar(value, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray scalar(IComplexFloat value) {
        IComplexNDArray ret = INSTANCE.scalar(value);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray scalar(IComplexDouble value) {
        IComplexNDArray ret = INSTANCE.scalar(value);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray scalar(IComplexNumber value) {
        IComplexNDArray ret = INSTANCE.scalar(value);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray scalar(IComplexFloat value, int offset) {
        IComplexNDArray ret = INSTANCE.scalar(value, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray scalar(IComplexDouble value, int offset) {
        IComplexNDArray ret = INSTANCE.scalar(value, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static int[] getStrides(int[] shape, char order) {
        if (order == 'f') {
            return ArrayUtil.calcStridesFortran(shape);
        }
        return ArrayUtil.calcStrides(shape);
    }

    public static int[] getStrides(int[] shape) {
        return Nd4j.getStrides(shape, Nd4j.order().charValue());
    }

    public static INDArray tile(INDArray tile, int ... repeat) {
        return tile.repmat(repeat);
    }

    public static int[] getComplexStrides(int[] shape, char order) {
        if (order == 'f') {
            return ArrayUtil.calcStridesFortran(shape, 2);
        }
        return ArrayUtil.calcStrides(shape, 2);
    }

    public static int[] getComplexStrides(int[] shape) {
        return Nd4j.getComplexStrides(shape, Nd4j.order().charValue());
    }

    public static IComplexNDArray createComplex(float[] data, int rows, int columns, int[] stride, int offset, char ordering) {
        IComplexNDArray ret = INSTANCE.createComplex(data, rows, columns, stride, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(float[] data, int rows, int columns, int[] stride, int offset, char ordering) {
        INDArray ret = INSTANCE.create(data, rows, columns, stride, offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(int[] shape, DataBuffer.Type dataType) {
        INDArray ret = INSTANCE.create(shape, dataType);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(float[] data, int[] shape, int[] stride, int offset, char ordering) {
        IComplexNDArray ret = INSTANCE.createComplex(data, shape, stride, offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(double[] data, int[] shape, int[] stride, int offset, char ordering) {
        INDArray ret = INSTANCE.create(data, shape, stride, offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(double[] data, int[] shape, char ordering) {
        INDArray ret = INSTANCE.create(data, shape, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(float[] data, int[] shape, char ordering) {
        INDArray ret = INSTANCE.create(data, shape, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(float[] data, int[] shape, char ordering) {
        IComplexNDArray ret = INSTANCE.createComplex(data, shape, (int)ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(double[] data, int[] shape, char ordering) {
        IComplexNDArray ret = INSTANCE.createComplex(data, shape, (int)ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(float[] data, int[] shape, int[] stride, char ordering) {
        IComplexNDArray ret = INSTANCE.createComplex(data, shape, stride, (int)ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(double[] data, int[] shape, int[] stride, char ordering) {
        IComplexNDArray ret = INSTANCE.createComplex(data, shape, stride, (int)ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(double[] data, int rows, int columns, int[] stride, int offset, char ordering) {
        IComplexNDArray ret = INSTANCE.createComplex(data, rows, columns, stride, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(double[] data, int rows, int columns, int[] stride, int offset, char ordering) {
        INDArray ret = INSTANCE.create(data, rows, columns, stride, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(double[] data, int[] shape, int[] stride, int offset, char ordering) {
        IComplexNDArray ret = INSTANCE.createComplex(data, shape, stride, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(float[] data, int[] shape, int[] stride, int offset, char ordering) {
        INDArray ret = INSTANCE.create(data, shape, stride, offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(List<INDArray> list, int[] shape, char ordering) {
        INDArray ret = INSTANCE.create(list, shape, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(int rows, int columns, int[] stride, int offset, char ordering) {
        IComplexNDArray ret = INSTANCE.createComplex(new int[]{rows, columns}, stride, offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(int rows, int columns, int[] stride, int offset, char ordering) {
        INDArray ret = INSTANCE.create(new int[]{rows, columns}, stride, offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(int[] shape, int[] stride, int offset, char ordering) {
        IComplexNDArray ret = INSTANCE.createComplex(shape, stride, offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(int[] shape, int[] stride, int offset, char ordering) {
        INDArray ret = INSTANCE.create(shape, stride, offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(int rows, int columns, int[] stride, char ordering) {
        IComplexNDArray ret = INSTANCE.createComplex(new int[]{rows, columns}, stride, (int)ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(int rows, int columns, int[] stride, char ordering) {
        INDArray ret = INSTANCE.create(new int[]{rows, columns}, stride, 0, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(int[] shape, int[] stride, char ordering) {
        return Nd4j.createComplex(shape, stride, 0, ordering);
    }

    public static INDArray create(int[] shape, int[] stride, char ordering) {
        INDArray ret = INSTANCE.create(shape, stride, 0, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(int rows, int columns, char ordering) {
        int[] shape = new int[]{rows, columns};
        IComplexNDArray ret = INSTANCE.createComplex(shape, Nd4j.getComplexStrides(shape, ordering), 0, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(int rows, int columns, char ordering) {
        INDArray ret = INSTANCE.create(rows, columns, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(int[] shape, char ordering) {
        IComplexNDArray ret = INSTANCE.createComplex(Nd4j.createBuffer(ArrayUtil.prod(shape) * 2), shape, 0, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(int[] shape, char ordering) {
        INDArray ret = INSTANCE.create(shape, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(float[] data, int[] shape, int offset, char ordering) {
        IComplexNDArray ret = INSTANCE.createComplex(data, shape, Nd4j.getComplexStrides(shape, ordering), offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(double[] data, int[] shape, int offset) {
        return Nd4j.createComplex(data, shape, offset, Nd4j.order().charValue());
    }

    public static INDArray create(double[] data, int[] shape, int offset) {
        INDArray ret = INSTANCE.create(data, shape, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(double[] data, int[] ints, int offset, char ordering) {
        IComplexNDArray ret = INSTANCE.createComplex(data, ints, offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(double[] dim) {
        IComplexNDArray ret = INSTANCE.createComplex(dim, new int[]{1, dim.length / 2});
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(float[] data, int[] shape, int offset) {
        IComplexNDArray ret = INSTANCE.createComplex(data, shape, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(float[][] doubles) {
        return INSTANCE.create(doubles);
    }

    public static IComplexNDArray complexLinSpace(int i, int i1, int i2) {
        return Nd4j.createComplex(Nd4j.linspace(i, i1, i2));
    }

    public static INDArray create(float[] data, int[] shape, int[] stride, char ordering, int offset) {
        INDArray ret = INSTANCE.create(data, shape, stride, offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(float[] data, int[] shape, char ordering, int offset) {
        INDArray ret = INSTANCE.create(data, shape, Nd4j.getStrides(shape, ordering), offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(DataBuffer data, int[] shape, int[] strides, int offset) {
        INDArray ret = INSTANCE.create(data, shape, strides, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(DataBuffer data, int[] shape, int offset) {
        INDArray ret = INSTANCE.create(data, shape, Nd4j.getStrides(shape), offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(DataBuffer data, int[] newShape, int[] newStride, int offset, char ordering) {
        INDArray ret = INSTANCE.create(data, newShape, newStride, offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(DataBuffer data, int[] newShape, int[] newStrides, int offset) {
        IComplexNDArray ret = INSTANCE.createComplex(data, newShape, newStrides, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(DataBuffer data, int[] shape, int offset) {
        IComplexNDArray ret = INSTANCE.createComplex(data, shape, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(DataBuffer data, int[] newDims, int[] newStrides, int offset, char ordering) {
        IComplexNDArray ret = INSTANCE.createComplex(data, newDims, newStrides, offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(DataBuffer data, int[] shape, int offset, char ordering) {
        IComplexNDArray ret = INSTANCE.createComplex(data, shape, offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(DataBuffer data, int[] shape) {
        INDArray ret = INSTANCE.create(data, shape);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(DataBuffer data, int[] shape) {
        IComplexNDArray ret = INSTANCE.createComplex(data, shape);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(DataBuffer buffer) {
        INDArray ret = INSTANCE.create(buffer);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public synchronized void initContext() {
        try {
            Nd4jBackend backend = Nd4jBackend.load();
            this.initWithBackend(backend);
        }
        catch (Nd4jBackend.NoAvailableBackendException e) {
            throw new RuntimeException(e);
        }
    }

    public void initWithBackend(Nd4jBackend backend) {
        try {
            Resource c = backend.getConfigurationResource();
            props = new Properties();
            props.load(c.getInputStream());
            for (String key : props.stringPropertyNames()) {
                System.setProperty(key, props.getProperty(key));
            }
            String otherDtype = System.getProperty(DTYPE, props.get(DTYPE).toString());
            String otherAlloc = System.getProperty(ALLOC, props.getProperty(ALLOC, "heap"));
            dtype = otherDtype.equals("float") ? DataBuffer.Type.FLOAT : DataBuffer.Type.DOUBLE;
            alloc = otherAlloc.equals("heap") ? DataBuffer.AllocationMode.HEAP : DataBuffer.AllocationMode.DIRECT;
            copyOnOps = Boolean.parseBoolean(props.getProperty(COPY_OPS, "true"));
            shouldInstrument = Boolean.parseBoolean(props.getProperty(INSTRUMENTATION, "false"));
            resourceManagerOn = Boolean.parseBoolean(props.getProperty(RESOURCE_MANGER_ON, "false"));
            ORDER = System.getProperty(ORDER_KEY, props.getProperty(ORDER_KEY, "c").toString()).charAt(0);
            opExecutionerClazz = Class.forName(props.getProperty(OP_EXECUTIONER, DefaultOpExecutioner.class.getName()));
            fftInstanceClazz = Class.forName(System.getProperty(FFT_OPS, DefaultFFTInstance.class.getName()));
            ndArrayFactoryClazz = Class.forName(System.getProperty(NDARRAY_FACTORY_CLASS, props.get(NDARRAY_FACTORY_CLASS).toString()));
            convolutionInstanceClazz = Class.forName(System.getProperty(CONVOLUTION_OPS, DefaultConvolutionInstance.class.getName()));
            String defaultName = props.getProperty(DATA_BUFFER_OPS, DefaultDataBufferFactory.class.getName());
            dataBufferFactoryClazz = Class.forName(System.getProperty(DATA_BUFFER_OPS, defaultName));
            String rand = props.getProperty(RANDOM, DefaultRandom.class.getName());
            randomClazz = Class.forName(rand);
            instrumentationClazz = Class.forName(props.getProperty(INSTRUMENTATION, InMemoryInstrumentation.class.getName()));
            opFactoryClazz = Class.forName(System.getProperty(OP_FACTORY, DefaultOpFactory.class.getName()));
            blasWrapperClazz = Class.forName(System.getProperty(BLAS_OPS, props.get(BLAS_OPS).toString()));
            String clazzName = props.getProperty(DISTRIBUTION, DefaultDistributionFactory.class.getName());
            distributionFactoryClazz = Class.forName(clazzName);
            instrumentation = instrumentationClazz.newInstance();
            OP_EXECUTIONER_INSTANCE = opExecutionerClazz.newInstance();
            FFT_INSTANCE = fftInstanceClazz.newInstance();
            Constructor<? extends NDArrayFactory> c2 = ndArrayFactoryClazz.getConstructor(DataBuffer.Type.class, Character.TYPE);
            INSTANCE = c2.newInstance(new Object[]{dtype, Character.valueOf(ORDER)});
            CONVOLUTION_INSTANCE = convolutionInstanceClazz.newInstance();
            BLAS_WRAPPER_INSTANCE = blasWrapperClazz.newInstance();
            DATA_BUFFER_FACTORY_INSTANCE = dataBufferFactoryClazz.newInstance();
            OP_FACTORY_INSTANCE = opFactoryClazz.newInstance();
            random = randomClazz.newInstance();
            UNIT = Nd4j.createFloat(1.0f, 0.0f);
            ZERO = Nd4j.createFloat(0.0f, 0.0f);
            NEG_UNIT = Nd4j.createFloat(-1.0f, 0.0f);
            ENFORCE_NUMERICAL_STABILITY = Boolean.parseBoolean(System.getProperty(NUMERICAL_STABILITY, String.valueOf(false)));
            DISTRIBUTION_FACTORY = distributionFactoryClazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static IComplexNDArray createComplex(IComplexNumber[] iComplexNumbers) {
        return Nd4j.createComplex(iComplexNumbers, new int[]{1, iComplexNumbers.length});
    }

    public static IComplexNDArray createComplex(IComplexNumber[][] iComplexNumbers) {
        IComplexNDArray shape = Nd4j.createComplex(iComplexNumbers.length, iComplexNumbers[0].length);
        for (int i = 0; i < iComplexNumbers.length; ++i) {
            for (int j = 0; j < iComplexNumbers[i].length; ++j) {
                shape.putScalar(i, j, iComplexNumbers[i][j]);
            }
        }
        return shape;
    }

    static {
        EPS_THRESHOLD = 1.0E-5f;
        MAX_ELEMENTS_PER_SLICE = 3;
        MAX_SLICES_TO_PRINT = 3;
        ENFORCE_NUMERICAL_STABILITY = false;
        copyOnOps = true;
        shouldInstrument = false;
        resourceManagerOn = false;
        props = new Properties();
        referenceQueue = new ReferenceQueue();
        bufferQueue = new ReferenceQueue();
        Nd4j nd4j = new Nd4j();
        nd4j.initContext();
    }
}

