/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.TransformOp;
import org.nd4j.linalg.api.ops.impl.transforms.OneMinus;
import org.nd4j.linalg.util.ComplexUtil;

public class Tanh
extends BaseTransformOp {
    public Tanh() {
    }

    public Tanh(INDArray x, INDArray z) {
        super(x, z);
    }

    public Tanh(INDArray x, INDArray z, int n) {
        super(x, z, n);
    }

    public Tanh(INDArray x, INDArray y, INDArray z, int n) {
        super(x, y, z, n);
    }

    public Tanh(INDArray x) {
        super(x);
    }

    @Override
    public String name() {
        return "tanh";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        return ComplexUtil.tanh(origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        return ComplexUtil.tanh(origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        return ComplexUtil.tanh(origin);
    }

    @Override
    public float op(float origin, float other) {
        return (float)FastMath.tanh((double)origin);
    }

    @Override
    public double op(double origin, double other) {
        return FastMath.tanh((double)origin);
    }

    @Override
    public double op(double origin) {
        return FastMath.tanh((double)origin);
    }

    @Override
    public float op(float origin) {
        return (float)FastMath.tanh((double)origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        return ComplexUtil.tanh(origin);
    }

    @Override
    public TransformOp derivative() {
        return new OneMinus(this.x, this.y, this.z, this.n);
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new Tanh(xAlongDimension, this.y.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new Tanh(xAlongDimension, this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
    }
}

