/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.TransformOp;
import org.nd4j.linalg.api.ops.impl.accum.Max;
import org.nd4j.linalg.api.ops.impl.accum.Sum;
import org.nd4j.linalg.api.ops.impl.transforms.SoftMaxDerivative;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.ops.transforms.Transforms;

public class SoftMax
extends BaseTransformOp {
    private Number sum;
    private Number max;
    private IComplexNumber maxComplex;
    private IComplexNumber sumComplex;

    public SoftMax() {
    }

    public SoftMax(INDArray x, INDArray z) {
        super(x, z);
    }

    public SoftMax(INDArray x, INDArray z, int n) {
        super(x, z, n);
    }

    public SoftMax(INDArray x, INDArray y, INDArray z, int n) {
        super(x, y, z, n);
    }

    public SoftMax(INDArray x) {
        super(x);
    }

    @Override
    public String name() {
        return "softmax";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        IComplexNDArray arr = (IComplexNDArray)this.y;
        IComplexNumber ret = arr.getComplex(this.numProcessed);
        ++this.numProcessed;
        return ret;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        IComplexNDArray arr = (IComplexNDArray)this.y;
        IComplexNumber ret = arr.getComplex(this.numProcessed);
        ++this.numProcessed;
        return ret;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        IComplexNDArray arr = (IComplexNDArray)this.y;
        IComplexNumber ret = arr.getComplex(this.numProcessed);
        ++this.numProcessed;
        return ret;
    }

    @Override
    public float op(float origin, float other) {
        float ret = other;
        ++this.numProcessed;
        return ret;
    }

    @Override
    public double op(double origin, double other) {
        double ret = other;
        ++this.numProcessed;
        return ret;
    }

    @Override
    public double op(double origin) {
        double ret = this.y.getDouble(this.numProcessed);
        ++this.numProcessed;
        return ret;
    }

    @Override
    public float op(float origin) {
        float ret = this.y.getFloat(this.numProcessed);
        ++this.numProcessed;
        return ret;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        IComplexNDArray arr = (IComplexNDArray)this.y;
        IComplexNumber ret = arr.getComplex(this.numProcessed);
        ++this.numProcessed;
        return ret;
    }

    @Override
    public TransformOp derivative() {
        return new SoftMaxDerivative(this.x, this.y, this.z, this.n);
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new SoftMax(xAlongDimension, this.y.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new SoftMax(xAlongDimension, this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
    }

    @Override
    public void init(INDArray x, INDArray y, INDArray z, int n) {
        super.init(x, y, z, n);
        if (x instanceof IComplexNDArray) {
            this.maxComplex = Nd4j.getExecutioner().execAndReturn(new Max(x)).currentResultComplex();
            IComplexNDArray complexX = (IComplexNDArray)x;
            this.y = Transforms.exp(complexX.sub(this.maxComplex));
            this.sumComplex = Nd4j.getExecutioner().execAndReturn(new Sum(y)).currentResultComplex();
            this.y.divi(this.sumComplex);
            this.extraArgs = new Object[]{this.maxComplex, this.sumComplex};
        } else {
            this.max = Nd4j.getExecutioner().execAndReturn(new Max(x)).currentResult();
            INDArray xMinusMax = x.sub(this.max);
            this.y = Transforms.exp(xMinusMax);
            this.sum = Nd4j.getExecutioner().execAndReturn(new Sum(this.y)).currentResult();
            this.y.divi(this.sum);
            this.extraArgs = new Object[]{this.max, this.sum};
        }
    }
}

