/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.TransformOp;
import org.nd4j.linalg.util.ComplexUtil;

public class Exp
extends BaseTransformOp {
    public Exp() {
    }

    public Exp(INDArray x, INDArray z) {
        super(x, z);
    }

    public Exp(INDArray x, INDArray z, int n) {
        super(x, z, n);
    }

    public Exp(INDArray x, INDArray y, INDArray z, int n) {
        super(x, y, z, n);
    }

    public Exp(INDArray x) {
        super(x);
    }

    @Override
    public String name() {
        return "exp";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        return ComplexUtil.exp(origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        return ComplexUtil.exp(origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        return ComplexUtil.exp(origin);
    }

    @Override
    public float op(float origin, float other) {
        return (float)FastMath.exp((double)origin);
    }

    @Override
    public double op(double origin, double other) {
        return FastMath.exp((double)origin);
    }

    @Override
    public double op(double origin) {
        return FastMath.exp((double)origin);
    }

    @Override
    public float op(float origin) {
        return (float)FastMath.exp((double)origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        return ComplexUtil.exp(origin);
    }

    @Override
    public TransformOp derivative() {
        return this;
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new Exp(xAlongDimension, this.y.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new Exp(xAlongDimension, this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
    }
}

