/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum;

import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseAccumulation;
import org.nd4j.linalg.api.ops.Op;

public class Sum
extends BaseAccumulation {
    public Sum() {
    }

    public Sum(INDArray x, INDArray y, INDArray z, int n) {
        super(x, y, z, n);
    }

    public Sum(INDArray x, INDArray y, int n) {
        super(x, y, n);
    }

    public Sum(INDArray x) {
        super(x);
    }

    public Sum(INDArray x, INDArray y) {
        super(x, y);
    }

    @Override
    public void update(Number result) {
        this.currentResult = this.currentResult.doubleValue() + result.doubleValue();
        ++this.numProcessed;
    }

    @Override
    public void update(IComplexNumber result) {
        this.currentComplexResult.addi(result);
        ++this.numProcessed;
    }

    @Override
    public String name() {
        return "sum";
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new Sum(xAlongDimension, this.y.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new Sum(xAlongDimension);
    }
}

