/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops;

import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.Op;

public abstract class BaseOp
implements Op {
    protected INDArray x;
    protected INDArray y;
    protected INDArray z;
    protected int n;
    protected int numProcessed;
    protected Object[] extraArgs;
    protected boolean passThrough;

    public BaseOp() {
    }

    @Override
    public boolean isPassThrough() {
        return this.passThrough;
    }

    @Override
    public void setX(INDArray x) {
        if (x == null) {
            throw new IllegalArgumentException("X must not be null");
        }
        this.x = x;
        this.numProcessed = 0;
        this.n = x.length();
    }

    @Override
    public void setZ(INDArray z) {
        if (z == null) {
            throw new IllegalArgumentException("Z must not be null");
        }
        this.z = z;
        this.numProcessed = 0;
        this.n = z.length();
    }

    @Override
    public void setY(INDArray y) {
        if (y == null) {
            throw new IllegalArgumentException("Y must not be null");
        }
        this.y = y;
        this.numProcessed = 0;
        this.n = y.length();
    }

    public BaseOp(INDArray x, INDArray z) {
        this(x, z, x.length());
    }

    public BaseOp(INDArray x, INDArray z, int n) {
        this(x, null, z, n);
    }

    public BaseOp(INDArray x, INDArray y, INDArray z, int n) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.n = n;
        this.init(x, y, z, n);
    }

    public BaseOp(INDArray x) {
        this(x, null, x, x.length());
    }

    @Override
    public Object[] extraArgs() {
        return this.extraArgs;
    }

    @Override
    public INDArray x() {
        return this.x;
    }

    @Override
    public INDArray y() {
        return this.y;
    }

    @Override
    public INDArray z() {
        return this.z;
    }

    @Override
    public int n() {
        return this.n;
    }

    @Override
    public void init(INDArray x, INDArray y, INDArray z, int n) {
    }

    @Override
    public int numProcessed() {
        return this.numProcessed;
    }

    public String toString() {
        return this.name();
    }

    @Override
    public void exec() {
    }
}

