/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.ops.transforms;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.ops.BaseElementWiseOp;

public class Stabilize
extends BaseElementWiseOp {
    private double k = 1.0;

    public Stabilize(Double k) {
        this.k = k;
    }

    public Stabilize(Float k) {
        this.k = k.floatValue();
    }

    public Stabilize(double k) {
        this.k = k;
    }

    public Stabilize() {
    }

    public Object apply(INDArray from, Object value, int i) {
        double realMin = 1.1755E-38f;
        double cutOff = FastMath.log((double)realMin);
        if (value instanceof IComplexNumber) {
            IComplexNumber c = (IComplexNumber)value;
            double curr = c.realComponent().doubleValue();
            if (curr * this.k > -cutOff) {
                return Nd4j.createDouble(-cutOff / this.k, c.imaginaryComponent().doubleValue());
            }
            if (curr * this.k < cutOff) {
                return Nd4j.createDouble(cutOff / this.k, c.imaginaryComponent().doubleValue());
            }
        } else {
            double curr = (Double)value;
            if (curr * this.k > -cutOff) {
                return -cutOff / this.k;
            }
            if (curr * this.k < cutOff) {
                return cutOff / this.k;
            }
        }
        return value;
    }
}

