/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.convolution;

import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.convolution.Convolution;
import org.nd4j.linalg.convolution.ConvolutionInstance;
import org.nd4j.linalg.util.ArrayUtil;

public abstract class BaseConvolution
implements ConvolutionInstance {
    @Override
    public INDArray conv2d(INDArray input, INDArray kernel, Convolution.Type type) {
        int[] shape = input.shape().length < 2 ? ArrayUtil.range(0, 1) : ArrayUtil.range(input.shape().length - 2, input.shape().length);
        return this.convn(input, kernel, type, shape);
    }

    @Override
    public INDArray conv2d(IComplexNDArray input, IComplexNDArray kernel, Convolution.Type type) {
        int[] shape = input.shape().length < 2 ? ArrayUtil.range(0, 1) : ArrayUtil.range(input.shape().length - 2, input.shape().length);
        return this.convn(input, kernel, type, shape);
    }

    @Override
    public INDArray convn(INDArray input, INDArray kernel, Convolution.Type type) {
        return this.convn(input, kernel, type, ArrayUtil.range(0, input.shape().length));
    }

    @Override
    public IComplexNDArray convn(IComplexNDArray input, IComplexNDArray kernel, Convolution.Type type) {
        return this.convn(input, kernel, type, ArrayUtil.range(0, input.shape().length));
    }
}

