/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.complex;

import org.nd4j.linalg.api.complex.IComplexDouble;
import org.nd4j.linalg.api.complex.IComplexFloat;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.factory.Nd4j;

public abstract class BaseComplexFloat
implements IComplexFloat {
    protected float real;
    protected float imag;

    public BaseComplexFloat(float real, float imag) {
        this.real = real;
        this.imag = imag;
    }

    public BaseComplexFloat(float real) {
        this(real, 0.0f);
    }

    @Override
    public IComplexNumber eqc(IComplexNumber num) {
        double val = num.realComponent().doubleValue();
        double imag = num.imaginaryComponent().doubleValue();
        double otherVal = num.realComponent().doubleValue();
        double otherImag = num.imaginaryComponent().doubleValue();
        if (val == otherVal) {
            return Nd4j.createComplexNumber(1, 0);
        }
        if (val != otherVal) {
            return Nd4j.createComplexNumber(0, 0);
        }
        if (imag == otherImag) {
            return Nd4j.createComplexNumber(1, 0);
        }
        return Nd4j.createComplexNumber(0, 0);
    }

    @Override
    public IComplexNumber neqc(IComplexNumber num) {
        double val = num.realComponent().doubleValue();
        double imag = num.imaginaryComponent().doubleValue();
        double otherVal = num.realComponent().doubleValue();
        double otherImag = num.imaginaryComponent().doubleValue();
        if (val != otherVal) {
            return Nd4j.createComplexNumber(1, 0);
        }
        if (val == otherVal) {
            return Nd4j.createComplexNumber(0, 0);
        }
        if (imag != otherImag) {
            return Nd4j.createComplexNumber(1, 0);
        }
        return Nd4j.createComplexNumber(0, 0);
    }

    @Override
    public IComplexNumber gt(IComplexNumber num) {
        double val = num.realComponent().doubleValue();
        double imag = num.imaginaryComponent().doubleValue();
        double otherVal = num.realComponent().doubleValue();
        double otherImag = num.imaginaryComponent().doubleValue();
        if (val > otherVal) {
            return Nd4j.createComplexNumber(1, 0);
        }
        if (val < otherVal) {
            return Nd4j.createComplexNumber(0, 0);
        }
        if (imag > otherImag) {
            return Nd4j.createComplexNumber(1, 0);
        }
        return Nd4j.createComplexNumber(0, 0);
    }

    @Override
    public IComplexNumber lt(IComplexNumber num) {
        double val = num.realComponent().doubleValue();
        double imag = num.imaginaryComponent().doubleValue();
        double otherVal = num.realComponent().doubleValue();
        double otherImag = num.imaginaryComponent().doubleValue();
        if (val < otherVal) {
            return Nd4j.createComplexNumber(1, 0);
        }
        if (val > otherVal) {
            return Nd4j.createComplexNumber(0, 0);
        }
        if (imag < otherImag) {
            return Nd4j.createComplexNumber(1, 0);
        }
        return Nd4j.createComplexNumber(0, 0);
    }

    @Override
    public IComplexDouble asDouble() {
        return Nd4j.createDouble(this.realComponent().floatValue(), this.imaginaryComponent().floatValue());
    }

    @Override
    public IComplexFloat asFloat() {
        return this;
    }

    @Override
    public IComplexFloat conji() {
        this.set(this.realComponent(), Float.valueOf(-this.imaginaryComponent().floatValue()));
        return this;
    }

    @Override
    public IComplexNumber conj() {
        return this.dup().conji();
    }

    @Override
    public IComplexNumber set(Number real, Number imag) {
        this.real = real.floatValue();
        this.imag = imag.floatValue();
        return this;
    }

    @Override
    public IComplexNumber copy(IComplexNumber other) {
        return Nd4j.createFloat(other.realComponent().floatValue(), other.imaginaryComponent().floatValue());
    }

    @Override
    public IComplexNumber addi(IComplexNumber c, IComplexNumber result) {
        if (this == result) {
            this.set(Float.valueOf(this.realComponent().floatValue() + c.realComponent().floatValue()), Float.valueOf(this.imaginaryComponent().floatValue() + result.imaginaryComponent().floatValue()));
        } else {
            result.set(Float.valueOf(result.realComponent().floatValue() + c.realComponent().floatValue()), Float.valueOf(result.imaginaryComponent().floatValue() + c.imaginaryComponent().floatValue()));
        }
        return this;
    }

    @Override
    public IComplexNumber addi(IComplexNumber c) {
        return this.addi(c, (IComplexNumber)this);
    }

    @Override
    public IComplexNumber add(IComplexNumber c) {
        return this.dup().addi(c);
    }

    @Override
    public IComplexNumber addi(Number a, IComplexNumber result) {
        if (this == result) {
            this.set(Float.valueOf(this.realComponent().floatValue() + a.floatValue()), Float.valueOf(this.imaginaryComponent().floatValue() + a.floatValue()));
        } else {
            result.set(Float.valueOf(result.realComponent().floatValue() + a.floatValue()), Float.valueOf(this.imaginaryComponent().floatValue() + a.floatValue()));
        }
        return result;
    }

    @Override
    public IComplexNumber addi(Number c) {
        return this.addi(c, (IComplexNumber)this);
    }

    @Override
    public IComplexNumber add(Number c) {
        return this.dup().addi(c);
    }

    @Override
    public IComplexNumber subi(IComplexNumber c, IComplexNumber result) {
        if (this != result) {
            return result.set(Float.valueOf(result.realComponent().floatValue() - c.realComponent().floatValue()), Float.valueOf(result.imaginaryComponent().floatValue() - c.imaginaryComponent().floatValue()));
        }
        this.set(Float.valueOf(this.realComponent().floatValue() - c.realComponent().floatValue()), Float.valueOf(this.imaginaryComponent().floatValue() - result.imaginaryComponent().floatValue()));
        return this;
    }

    @Override
    public IComplexNumber subi(IComplexNumber c) {
        return this.subi(c, (IComplexNumber)this);
    }

    @Override
    public IComplexNumber sub(IComplexNumber c) {
        return this.dup().subi(c);
    }

    @Override
    public IComplexNumber subi(Number a, IComplexNumber result) {
        if (this != result) {
            return result.set(Float.valueOf(result.realComponent().floatValue() - a.floatValue()), Float.valueOf(this.imaginaryComponent().floatValue() - a.floatValue()));
        }
        this.set(Float.valueOf(this.realComponent().floatValue() - a.floatValue()), Float.valueOf(this.imaginaryComponent().floatValue() - a.floatValue()));
        return result;
    }

    @Override
    public IComplexNumber subi(Number a) {
        return this.subi(a, (IComplexNumber)this);
    }

    @Override
    public IComplexNumber sub(Number r) {
        return this.dup().subi(r);
    }

    @Override
    public IComplexNumber muli(IComplexNumber c, IComplexNumber result) {
        float newR = this.realComponent().floatValue() * c.realComponent().floatValue() - this.imaginaryComponent().floatValue() * c.imaginaryComponent().floatValue();
        float newI = this.realComponent().floatValue() * c.imaginaryComponent().floatValue() + this.imaginaryComponent().floatValue() * c.realComponent().floatValue();
        result.set(Float.valueOf(newR), Float.valueOf(newI));
        return result;
    }

    @Override
    public IComplexNumber muli(IComplexNumber c) {
        return this.muli(c, (IComplexNumber)this);
    }

    @Override
    public IComplexNumber mul(IComplexNumber c) {
        return this.dup().muli(c);
    }

    @Override
    public IComplexNumber mul(Number v) {
        return this.dup().muli(v);
    }

    @Override
    public IComplexNumber muli(Number v, IComplexNumber result) {
        if (this == result) {
            this.set(Float.valueOf(this.realComponent().floatValue() * v.floatValue()), Float.valueOf(this.imaginaryComponent().floatValue() * v.floatValue()));
        } else {
            result.set(Float.valueOf(result.realComponent().floatValue() * v.floatValue()), Float.valueOf(result.imaginaryComponent().floatValue() * v.floatValue()));
        }
        return result;
    }

    @Override
    public IComplexNumber muli(Number v) {
        return this.muli(v, (IComplexNumber)this);
    }

    @Override
    public IComplexNumber div(IComplexNumber c) {
        return this.dup().divi(c);
    }

    @Override
    public IComplexNumber divi(IComplexNumber c, IComplexNumber result) {
        float d = c.realComponent().floatValue() * c.realComponent().floatValue() + c.imaginaryComponent().floatValue() * c.imaginaryComponent().floatValue();
        float newR = (this.realComponent().floatValue() * c.realComponent().floatValue() + this.imaginaryComponent().floatValue() * c.imaginaryComponent().floatValue()) / d;
        float newI = (this.imaginaryComponent().floatValue() * c.realComponent().floatValue() - this.realComponent().floatValue() * c.imaginaryComponent().floatValue()) / d;
        result.set(Float.valueOf(newR), Float.valueOf(newI));
        return result;
    }

    @Override
    public IComplexNumber divi(IComplexNumber c) {
        return this.divi(c, (IComplexNumber)this);
    }

    @Override
    public IComplexNumber divi(Number v, IComplexNumber result) {
        if (this == result) {
            this.set(Float.valueOf(this.realComponent().floatValue() / v.floatValue()), Float.valueOf(this.imaginaryComponent().floatValue() / v.floatValue()));
        } else {
            result.set(Float.valueOf(result.realComponent().floatValue() / v.floatValue()), Float.valueOf(this.imaginaryComponent().floatValue() / v.floatValue()));
        }
        return result;
    }

    @Override
    public IComplexNumber divi(Number v) {
        return this.divi(v, (IComplexNumber)this);
    }

    @Override
    public IComplexNumber div(Number v) {
        return this.dup().divi(v);
    }

    @Override
    public boolean eq(IComplexNumber c) {
        return false;
    }

    @Override
    public boolean ne(IComplexNumber c) {
        return false;
    }

    @Override
    public Float realComponent() {
        return Float.valueOf(this.real);
    }

    @Override
    public Float imaginaryComponent() {
        return Float.valueOf(this.imag);
    }

    @Override
    public IComplexFloat divi(float v) {
        this.real /= v;
        this.imag /= v;
        return this;
    }

    @Override
    public IComplexNumber div(float v) {
        return this.dup().divi(Float.valueOf(v));
    }

    @Override
    public Float absoluteValue() {
        return Float.valueOf((float)Math.sqrt(this.real * this.real + this.imag * this.imag));
    }

    @Override
    public Float complexArgument() {
        return Float.valueOf((float)Math.acos(this.realComponent().floatValue() / this.absoluteValue().floatValue()));
    }

    @Override
    public IComplexFloat invi() {
        float d = this.realComponent().floatValue() * this.realComponent().floatValue() + this.imaginaryComponent().floatValue() * this.imaginaryComponent().floatValue();
        this.set(Float.valueOf(this.realComponent().floatValue() / d), Float.valueOf(-this.imaginaryComponent().floatValue() / d));
        return this;
    }

    @Override
    public IComplexNumber inv() {
        return this.dup().invi();
    }

    @Override
    public IComplexNumber neg() {
        return this.dup().negi();
    }

    @Override
    public IComplexFloat negi() {
        this.set(Float.valueOf(-this.realComponent().floatValue()), Float.valueOf(-this.imaginaryComponent().floatValue()));
        return this;
    }

    @Override
    public IComplexFloat sqrt() {
        float a = this.absoluteValue().floatValue();
        float s2 = (float)Math.sqrt(2.0);
        float p = (float)Math.sqrt(a + this.realComponent().floatValue()) / s2;
        float q = (float)Math.sqrt(a - this.realComponent().floatValue()) / s2 * Math.signum(this.imaginaryComponent().floatValue());
        return Nd4j.createFloat(p, q);
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public boolean isZero() {
        return this.real == 0.0f;
    }

    @Override
    public boolean isReal() {
        return this.imaginaryComponent().floatValue() == 0.0f;
    }

    @Override
    public boolean isImag() {
        return this.realComponent().floatValue() == 0.0f;
    }

    public int hashCode() {
        int result = this.real != 0.0f ? Float.floatToIntBits(this.real) : 0;
        result = 31 * result + (this.imag != 0.0f ? Float.floatToIntBits(this.imag) : 0);
        return result;
    }

    public String toString() {
        if (this.imag >= 0.0f) {
            return this.real + " + " + this.imag + "i";
        }
        return this.real + " - " + -this.imag + "i";
    }
}

