/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.buffer;

import com.google.common.primitives.Bytes;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.UUID;
import org.nd4j.linalg.api.buffer.BaseDataBuffer;
import org.nd4j.linalg.api.buffer.DataBuffer;

public class DoubleBuffer
extends BaseDataBuffer {
    private double[] buffer;

    public DoubleBuffer(int length) {
        super(length);
        this.buffer = new double[length];
    }

    public DoubleBuffer(double[] buffer) {
        this(buffer, true);
    }

    public DoubleBuffer(double[] buffer, boolean copy) {
        super(buffer.length);
        this.buffer = copy ? Arrays.copyOf(buffer, buffer.length) : buffer;
    }

    @Override
    public byte[] asBytes() {
        byte[][] ret1 = new byte[this.length][];
        for (int i = 0; i < this.length; ++i) {
            ret1[i] = DoubleBuffer.toByteArray(this.buffer[i]);
        }
        return Bytes.concat((byte[][])ret1);
    }

    @Override
    public String dataType() {
        return "double";
    }

    @Override
    public float[] asFloat() {
        float[] ret = new float[this.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (float)this.buffer[i];
        }
        return ret;
    }

    @Override
    public double[] asDouble() {
        if (this.buffer == null) {
            this.buffer = new double[this.length];
            for (int i = 0; i < this.length; ++i) {
                this.buffer[i] = this.getDouble(i);
            }
            try {
                this.mappings.clear();
                this.memoryMappedBuffer.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.buffer;
    }

    @Override
    public int[] asInt() {
        int[] ret = new int[this.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (int)this.buffer[i];
        }
        return ret;
    }

    @Override
    public double getDouble(int i) {
        if (this.buffer != null) {
            return this.buffer[i];
        }
        long p = i * 8;
        int mapN = (int)(p / 0x40000000L);
        int offN = (int)(p % 0x40000000L);
        return ((ByteBuffer)this.mappings.get(mapN)).getDouble(offN);
    }

    @Override
    public float getFloat(int i) {
        return (float)this.getDouble(i);
    }

    @Override
    public Number getNumber(int i) {
        return (int)this.getDouble(i);
    }

    @Override
    public void put(int i, float element) {
        this.put(i, (double)element);
    }

    @Override
    public void put(int i, double element) {
        if (this.buffer != null) {
            this.buffer[i] = element;
        } else {
            long p = i * 8;
            int mapN = (int)(p / 0x40000000L);
            int offN = (int)(p % 0x40000000L);
            ((ByteBuffer)this.mappings.get(mapN)).putDouble(offN, element);
        }
    }

    @Override
    public void put(int i, int element) {
        this.put(i, (double)element);
    }

    @Override
    public int getInt(int ix) {
        return (int)this.buffer[ix];
    }

    @Override
    public DataBuffer dup() {
        return new DoubleBuffer(this.buffer);
    }

    @Override
    public void flush() {
        this.path = UUID.randomUUID().toString();
        if (this.memoryMappedBuffer != null) {
            return;
        }
        try {
            this.memoryMappedBuffer = new RandomAccessFile(this.path, "rw");
            long size = 8L * (long)this.length;
            for (long offset = 0L; offset < size; offset += 0x40000000L) {
                long size2 = Math.min(size - offset, 0x40000000L);
                this.mappings.add(this.memoryMappedBuffer.getChannel().map(FileChannel.MapMode.READ_WRITE, offset, size2));
            }
        }
        catch (IOException e) {
            try {
                if (this.memoryMappedBuffer != null) {
                    this.memoryMappedBuffer.close();
                }
            }
            catch (IOException e1) {
                throw new RuntimeException(e);
            }
            throw new RuntimeException(e);
        }
        this.buffer = null;
    }

    @Override
    public void destroy() {
        if (this.buffer != null) {
            this.buffer = null;
        }
        if (this.memoryMappedBuffer != null) {
            try {
                this.memoryMappedBuffer.close();
                this.mappings.clear();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DoubleBuffer)) {
            return false;
        }
        DoubleBuffer that = (DoubleBuffer)o;
        return Arrays.equals(this.buffer, that.buffer);
    }

    public int hashCode() {
        return this.buffer != null ? Arrays.hashCode(this.buffer) : 0;
    }
}

