/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.ops;

import java.util.concurrent.ExecutorService;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.ops.ElementWiseOp;

public abstract class BaseElementWiseOp
implements ElementWiseOp {
    protected INDArray from;
    protected Object scalarValue;
    protected static ExecutorService dimensionThreads;

    public static synchronized ExecutorService getThreads() {
        return dimensionThreads;
    }

    @Override
    public void applyTransformToOrigin(INDArray origin, int i) {
        if (origin instanceof IComplexNumber) {
            IComplexNDArray c2 = (IComplexNDArray)origin;
            IComplexNumber transformed = (IComplexNumber)this.apply(origin, this.getFromOrigin(origin, i), i);
            c2.putScalar(i, transformed);
        } else {
            Number f = (Number)this.apply(origin, this.getFromOrigin(origin, i), i);
            double val = f.doubleValue();
            if (Double.isNaN(val) || Double.isInfinite(val)) {
                val = Nd4j.EPS_THRESHOLD;
            }
            if (origin.data().dataType().equals("float")) {
                origin.putScalar(i, val);
            } else {
                origin.putScalar(i, val);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void applyTransformToOrigin(INDArray origin, int i, Object valueToApply) {
        if (valueToApply instanceof IComplexNumber) {
            if (!(origin instanceof IComplexNDArray)) throw new IllegalArgumentException("Unable to apply a non complex number to a real ndarray");
            IComplexNDArray c2 = (IComplexNDArray)origin;
            IComplexNumber apply = (IComplexNumber)this.apply(origin, valueToApply, i);
            c2.putScalar(i, apply);
            return;
        } else {
            Number f = (Number)this.apply(origin, valueToApply, i);
            double val = f.doubleValue();
            if (Double.isNaN(val) || Double.isInfinite(val)) {
                val = Nd4j.EPS_THRESHOLD;
            }
            if (origin.data().dataType().equals("float")) {
                origin.putScalar(i, val);
                return;
            } else {
                origin.putScalar(i, val);
            }
        }
    }

    public Object getFromOrigin(INDArray origin, int i) {
        if (origin instanceof IComplexNDArray) {
            IComplexNDArray c2 = (IComplexNDArray)origin;
            return c2.getComplex(i);
        }
        return origin.getDouble(i);
    }

    @Override
    public INDArray from() {
        return this.from;
    }

    @Override
    public void exec() {
        INDArray linear = this.from.linearView();
        if (linear instanceof IComplexNDArray) {
            IComplexNDArray cLinear = (IComplexNDArray)linear;
            for (int i = 0; i < cLinear.length(); ++i) {
                IComplexNumber result = (IComplexNumber)this.apply(cLinear, cLinear.getComplex(i), i);
                cLinear.putScalar(i, result);
            }
        } else {
            for (int i = 0; i < linear.length(); ++i) {
                double apply = (Double)this.apply(linear, linear.getDouble(i), i);
                if (Double.isInfinite(apply) || Double.isInfinite(apply)) {
                    apply = Nd4j.EPS_THRESHOLD;
                }
                this.from.putScalar(i, apply);
            }
        }
    }
}

