/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.factory;

import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.random.MersenneTwister;
import org.apache.commons.math3.random.RandomGenerator;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.DoubleBuffer;
import org.nd4j.linalg.api.buffer.FloatBuffer;
import org.nd4j.linalg.api.complex.IComplexDouble;
import org.nd4j.linalg.api.complex.IComplexFloat;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.DimensionSlice;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ndarray.SliceOp;
import org.nd4j.linalg.factory.NDArrayFactory;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.util.ArrayUtil;

public abstract class BaseNDArrayFactory
implements NDArrayFactory {
    protected String dtype;
    protected Character order;

    protected BaseNDArrayFactory(String dtype, Character order) {
        this.dtype = dtype;
        if (Character.toLowerCase(order.charValue()) != 'c' && Character.toLowerCase(order.charValue()) != 'f') {
            throw new IllegalArgumentException("Order must either be c or f");
        }
        this.order = order;
    }

    @Override
    public void setOrder(char order) {
        assert (order == 'c' || order == 'f') : "Order specified must be either c or f";
        this.order = Character.valueOf(order);
    }

    @Override
    public INDArray rand(int[] shape, double min, double max, RandomGenerator rng) {
        INDArray ret = this.create(shape);
        INDArray linear = ret.linearView();
        double r = max - min;
        for (int i = 0; i < ret.length(); ++i) {
            linear.putScalar(i, r * rng.nextDouble() + min);
        }
        return ret;
    }

    @Override
    public INDArray rand(int rows, int columns, double min, double max, RandomGenerator rng) {
        return this.rand(new int[]{rows, columns}, min, max, rng);
    }

    @Override
    public DataBuffer createBuffer(double[] concat, boolean copy) {
        return new DoubleBuffer(concat, copy);
    }

    @Override
    public DataBuffer createBuffer(float[] concat, boolean copy) {
        return new FloatBuffer(concat, copy);
    }

    @Override
    public void setDType(String dtype) {
        assert (dtype.equals("double") || dtype.equals("float")) : "Invalid type passed, must be float or double";
        this.dtype = dtype;
    }

    @Override
    public char order() {
        return this.order.charValue();
    }

    @Override
    public String dtype() {
        return this.dtype;
    }

    @Override
    public INDArray linspace(int lower, int upper, int num) {
        INDArray ret = this.create(num);
        for (int i = 0; i < num; ++i) {
            double t = (double)i / (double)(num - 1);
            ret.putScalar(i, (double)lower * (1.0 - t) + t * (double)upper);
        }
        return ret;
    }

    @Override
    public DataBuffer createBuffer(DataBuffer[] buffers) {
        this.assertAllSameType(buffers);
        if (buffers[0].dataType().equals("double")) {
            double[][] ret = new double[buffers.length][];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = buffers[i].asDouble();
            }
            return this.createBuffer(Doubles.concat((double[][])ret));
        }
        float[][] ret = new float[buffers.length][];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = buffers[i].asFloat();
        }
        return this.createBuffer(Floats.concat((float[][])ret));
    }

    @Override
    public INDArray create(int rows, int columns, char ordering) {
        return this.create(new int[]{rows, columns}, ordering);
    }

    @Override
    public DataBuffer createBuffer(double[] concat) {
        return new DoubleBuffer(concat);
    }

    @Override
    public DataBuffer createBuffer(float[] concat) {
        return new FloatBuffer(concat);
    }

    private int assertAllSameType(DataBuffer[] data) {
        String type = data[0].dataType();
        int ret = data[0].length();
        for (int i = 1; i < data.length; ++i) {
            assert (data[i].dataType().equals(type));
            ret += data[i].length();
        }
        return ret;
    }

    @Override
    public INDArray toFlattened(Collection<INDArray> matrices) {
        int length = 0;
        for (INDArray m : matrices) {
            length += m.length();
        }
        int linearIndex = 0;
        INDArray ret = Nd4j.create(length);
        for (INDArray d : matrices) {
            INDArray flattened = d.linearView();
            for (int i = 0; i < d.length(); ++i) {
                ret.putScalar(linearIndex++, flattened.getDouble(i));
            }
        }
        return ret;
    }

    @Override
    public INDArray toFlattened(int length, Iterator<? extends INDArray> ... matrices) {
        INDArray ret = Nd4j.create(length);
        int linearIndex = 0;
        for (Iterator<? extends INDArray> iter1 : matrices) {
            while (iter1.hasNext()) {
                INDArray d = iter1.next();
                INDArray flattened = d.linearView();
                for (int i = 0; i < d.length(); ++i) {
                    ret.putScalar(linearIndex++, flattened.getDouble(i));
                }
            }
        }
        return ret;
    }

    @Override
    public INDArray bilinearProducts(INDArray curr, INDArray in) {
        assert (curr.shape().length == 3);
        if (in.columns() != 1) {
            throw new AssertionError((Object)"Expected a column vector");
        }
        if (in.rows() != curr.size(curr.shape().length - 1)) {
            throw new AssertionError((Object)"Number of rows in the input does not match number of columns in tensor");
        }
        if (curr.size(curr.shape().length - 2) != curr.size(curr.shape().length - 1)) {
            throw new AssertionError((Object)"Can only perform this operation on a SimpleTensor with square slices");
        }
        INDArray ret = Nd4j.create(curr.slices(), 1);
        INDArray inT = in.transpose();
        for (int i = 0; i < curr.slices(); ++i) {
            INDArray slice = curr.slice(i);
            INDArray inTTimesSlice = inT.mmul(slice);
            ret.putScalar(i, Nd4j.getBlasWrapper().dot(inTTimesSlice, in));
        }
        return ret;
    }

    @Override
    public INDArray toFlattened(INDArray ... matrices) {
        int length = 0;
        for (INDArray m : matrices) {
            length += m.length();
        }
        INDArray ret = Nd4j.create(1, length);
        int linearIndex = 0;
        for (INDArray d : matrices) {
            if (!d.isVector()) {
                d = Nd4j.create(d.data(), new int[]{1, d.length()}, d.offset());
            }
            for (int i = 0; i < d.length(); ++i) {
                ret.putScalar(linearIndex++, d.getFloat(i));
            }
        }
        return ret;
    }

    @Override
    public INDArray eye(int n) {
        INDArray ret = Nd4j.create(n, n);
        for (int i = 0; i < n; ++i) {
            ret.put(i, i, 1.0);
        }
        return ret.reshape(n, n);
    }

    @Override
    public void rot90(INDArray toRotate) {
        if (!toRotate.isMatrix()) {
            throw new IllegalArgumentException("Only rotating matrices");
        }
        INDArray start = toRotate.transpose();
        for (int i = 0; i < start.rows(); ++i) {
            start.putRow(i, this.reverse(start.getRow(i)));
        }
    }

    @Override
    public INDArray rot(INDArray reverse) {
        INDArray ret = Nd4j.create(reverse.shape());
        if (reverse.isVector()) {
            return this.reverse(reverse);
        }
        for (int i = 0; i < reverse.slices(); ++i) {
            ret.putSlice(i, this.reverse(reverse.slice(i)));
        }
        return ret.reshape(reverse.shape());
    }

    @Override
    public INDArray reverse(INDArray reverse) {
        INDArray rev = reverse.linearView();
        INDArray ret = Nd4j.create(rev.shape());
        int count = 0;
        for (int i = rev.length() - 1; i >= 0; --i) {
            ret.putScalar(count++, rev.getFloat(i));
        }
        return ret.reshape(reverse.shape());
    }

    @Override
    public INDArray arange(double begin, double end) {
        return Nd4j.create(ArrayUtil.toDoubles(ArrayUtil.range((int)begin, (int)end)));
    }

    @Override
    public abstract IComplexFloat createFloat(float var1, float var2);

    @Override
    public abstract IComplexDouble createDouble(double var1, double var3);

    @Override
    public void copy(INDArray a, INDArray b) {
        a = a.linearView();
        b = b.linearView();
        for (int i = 0; i < a.length(); ++i) {
            b.put(i, a.getScalar(i));
        }
    }

    @Override
    public INDArray rand(int[] shape, float min, float max, RandomGenerator rng) {
        INDArray ret = Nd4j.create(shape);
        INDArray linear = ret.linearView();
        float r = max - min;
        for (int i = 0; i < ret.length(); ++i) {
            linear.putScalar(i, r * rng.nextFloat() + min);
        }
        return ret;
    }

    @Override
    public INDArray rand(int rows, int columns, float min, float max, RandomGenerator rng) {
        INDArray ret = Nd4j.create(rows, columns);
        INDArray linear = ret.linearView();
        float r = max - min;
        for (int i = 0; i < ret.length(); ++i) {
            linear.putScalar(i, r * rng.nextFloat() + min);
        }
        return ret;
    }

    @Override
    public INDArray appendBias(INDArray ... vectors) {
        int size = 0;
        for (INDArray vector : vectors) {
            size += vector.rows();
        }
        INDArray result = Nd4j.create(size + 1, vectors[0].columns());
        int index = 0;
        for (INDArray vector : vectors) {
            INDArray put = this.toFlattened(vector, Nd4j.ones(1));
            result.put(new NDArrayIndex[]{NDArrayIndex.interval(index, index + vector.rows() + 1), NDArrayIndex.interval(0, vectors[0].columns())}, put);
            index += vector.rows();
        }
        return result;
    }

    @Override
    public abstract IComplexNDArray createComplex(INDArray var1);

    @Override
    public abstract IComplexNDArray createComplex(IComplexNumber[] var1, int[] var2);

    @Override
    public abstract IComplexNDArray createComplex(List<IComplexNDArray> var1, int[] var2);

    @Override
    public INDArray rand(int rows, int columns, RandomGenerator r) {
        return this.rand(new int[]{rows, columns}, r);
    }

    @Override
    public INDArray rand(int rows, int columns, long seed) {
        return this.rand(new int[]{rows, columns}, (RandomGenerator)new MersenneTwister(seed));
    }

    @Override
    public INDArray rand(int rows, int columns) {
        return this.randn(new int[]{rows, columns}, System.currentTimeMillis());
    }

    @Override
    public INDArray randn(int rows, int columns, RandomGenerator r) {
        return this.randn(new int[]{rows, columns}, r);
    }

    @Override
    public INDArray randn(int rows, int columns) {
        return this.randn(new int[]{rows, columns}, System.currentTimeMillis());
    }

    @Override
    public INDArray randn(int rows, int columns, long seed) {
        return this.randn(new int[]{rows, columns}, (RandomGenerator)new MersenneTwister(seed));
    }

    @Override
    public INDArray rand(int[] shape, RealDistribution r) {
        INDArray ret = this.create(shape);
        INDArray linear = ret.linearView();
        for (int i = 0; i < ret.length(); ++i) {
            linear.putScalar(i, r.sample());
        }
        return ret;
    }

    @Override
    public INDArray rand(int[] shape, RandomGenerator r) {
        INDArray ret = this.create(shape);
        INDArray linear = ret.linearView();
        for (int i = 0; i < ret.length(); ++i) {
            linear.putScalar(i, r.nextDouble());
        }
        return ret;
    }

    @Override
    public INDArray rand(int[] shape, long seed) {
        return this.rand(shape, (RandomGenerator)new MersenneTwister(seed));
    }

    @Override
    public INDArray rand(int[] shape) {
        return this.rand(shape, System.currentTimeMillis());
    }

    @Override
    public INDArray randn(int[] shape, RandomGenerator r) {
        INDArray ret = this.create(shape);
        INDArray linear = ret.linearView();
        for (int i = 0; i < ret.length(); ++i) {
            linear.putScalar(i, r.nextGaussian());
        }
        return ret;
    }

    @Override
    public INDArray randn(int[] shape) {
        return this.randn(shape, System.currentTimeMillis());
    }

    @Override
    public INDArray randn(int[] shape, long seed) {
        return this.randn(shape, (RandomGenerator)new MersenneTwister(seed));
    }

    @Override
    public INDArray create(double[] data) {
        return this.create(data, new int[]{data.length});
    }

    @Override
    public INDArray create(float[] data) {
        return this.create(data, new int[]{data.length});
    }

    @Override
    public IComplexNDArray createComplex(double[] data) {
        assert (data.length % 2 == 0) : "Length of data must be even. A complex ndarray is made up of pairs of real and imaginary components";
        return this.createComplex(data, new int[]{data.length / 2});
    }

    @Override
    public INDArray create(int columns) {
        return this.create(new int[]{columns});
    }

    @Override
    public IComplexNDArray createComplex(int columns) {
        return this.createComplex(new int[]{columns});
    }

    @Override
    public INDArray zeros(int rows, int columns) {
        return this.zeros(new int[]{rows, columns});
    }

    @Override
    public IComplexNDArray complexZeros(int rows, int columns) {
        return this.createComplex(new int[]{rows, columns});
    }

    @Override
    public INDArray zeros(int columns) {
        return this.zeros(new int[]{columns});
    }

    @Override
    public IComplexNDArray complexZeros(int columns) {
        return this.createComplex(new int[]{columns});
    }

    @Override
    public IComplexNDArray complexValueOf(int[] shape, IComplexNumber value) {
        IComplexNDArray ones = this.complexOnes(shape);
        ones.assign(Nd4j.scalar(value));
        return ones;
    }

    @Override
    public IComplexNDArray complexValueOf(int num, double value) {
        IComplexNDArray ones = this.complexOnes(num);
        ones.assign(Nd4j.complexScalar(value));
        return ones;
    }

    @Override
    public IComplexNDArray complexValueOf(int[] shape, double value) {
        IComplexNDArray ones = this.complexOnes(shape);
        ones.assign(Nd4j.scalar(value));
        return ones;
    }

    @Override
    public IComplexNDArray complexValueOf(int num, IComplexNumber value) {
        IComplexNDArray ones = this.complexOnes(num);
        ones.assign(Nd4j.scalar(value));
        return ones;
    }

    @Override
    public INDArray valueArrayOf(int[] shape, double value) {
        INDArray create = this.create(shape);
        create.assign(value);
        return create;
    }

    @Override
    public INDArray valueArrayOf(int rows, int columns, double value) {
        INDArray create = this.create(rows, columns);
        create.assign(value);
        return create;
    }

    @Override
    public INDArray ones(int rows, int columns) {
        return this.ones(new int[]{rows, columns});
    }

    @Override
    public INDArray complexOnes(int rows, int columns) {
        return this.createComplex(new int[]{rows, columns});
    }

    @Override
    public INDArray ones(int columns) {
        return this.ones(new int[]{columns});
    }

    @Override
    public IComplexNDArray complexOnes(int columns) {
        IComplexNDArray base = this.createComplex(new int[]{columns});
        base.assign(1);
        return base;
    }

    @Override
    public INDArray concat(int dimension, INDArray ... toConcat) {
        if (toConcat.length == 1) {
            return toConcat[0];
        }
        BaseNDArrayFactory.validateConcat(dimension, toConcat);
        int sumAlongDim = 0;
        for (int i = 0; i < toConcat.length; ++i) {
            sumAlongDim += toConcat[i].shape()[dimension];
        }
        int[] outputShape = ArrayUtil.copy(toConcat[0].shape());
        outputShape[dimension] = sumAlongDim;
        INDArray ret = Nd4j.create(outputShape);
        INDArray linear = ret.linearView();
        int count = 0;
        for (int i = 0; i < toConcat.length; ++i) {
            INDArray flattened = toConcat[i].linearView();
            for (int j = 0; j < flattened.length(); ++j) {
                linear.putScalar(count++, flattened.getFloat(j));
            }
        }
        return ret;
    }

    @Override
    public IComplexNDArray concat(int dimension, IComplexNDArray ... toConcat) {
        if (toConcat.length == 1) {
            return toConcat[0];
        }
        BaseNDArrayFactory.validateConcat(dimension, toConcat);
        int sumAlongDim = 0;
        for (int i = 0; i < toConcat.length; ++i) {
            sumAlongDim += toConcat[i].shape()[dimension];
        }
        int[] outputShape = ArrayUtil.copy(toConcat[0].shape());
        outputShape[dimension] = sumAlongDim;
        IComplexNDArray ret = Nd4j.createComplex(outputShape);
        IComplexNDArray linear = ret.linearView();
        int count = 0;
        for (int i = 0; i < toConcat.length; ++i) {
            IComplexNDArray flattened = toConcat[i].linearView();
            for (int j = 0; j < flattened.length(); ++j) {
                linear.putScalar(count++, flattened.getComplex(j));
            }
        }
        return ret;
    }

    @Override
    public IComplexNDArray complexFlatten(IComplexNDArray[] flatten) {
        int length = 0;
        for (IComplexNDArray m : flatten) {
            length += m.length();
        }
        IComplexNDArray ret = Nd4j.createComplex(length);
        int linearIndex = 0;
        for (IComplexNDArray d : flatten) {
            IComplexNDArray flattened = d.linearView();
            for (int i = 0; i < d.length(); ++i) {
                ret.putScalar(linearIndex++, flattened.getComplex(i));
            }
        }
        return ret;
    }

    @Override
    public IComplexNDArray complexFlatten(List<IComplexNDArray> flatten) {
        int length = 0;
        for (IComplexNDArray m : flatten) {
            length += m.length();
        }
        IComplexNDArray ret = Nd4j.createComplex(length);
        int linearIndex = 0;
        for (IComplexNDArray d : flatten) {
            IComplexNDArray flattened = d.linearView();
            for (int i = 0; i < d.length(); ++i) {
                ret.putScalar(linearIndex++, flattened.getComplex(i));
            }
        }
        return ret;
    }

    protected static void validateConcat(int dimension, INDArray ... arrs) {
        int dims = arrs[0].shape().length;
        int[] shape = ArrayUtil.removeIndex(arrs[0].shape(), dimension);
        for (int i = 1; i < arrs.length; ++i) {
            assert (Arrays.equals(shape, ArrayUtil.removeIndex(arrs[i].shape(), dimension)));
            assert (arrs[i].shape().length == dims);
        }
    }

    @Override
    public INDArray hstack(INDArray ... arrs) {
        int cols = arrs[0].columns();
        int rows = arrs[0].rows();
        for (int i = 1; i < arrs.length; ++i) {
            cols += arrs[i].columns();
            if (arrs[i].rows() == rows) continue;
            throw new IllegalStateException("Illegal number of rows for array " + i);
        }
        final INDArray ret = Nd4j.create(rows, cols);
        final AtomicInteger i = new AtomicInteger(0);
        for (INDArray a : arrs) {
            a.iterateOverAllColumns(new SliceOp(){

                @Override
                public void operate(DimensionSlice nd) {
                }

                @Override
                public void operate(INDArray nd) {
                    for (int j = 0; j < nd.length(); ++j) {
                        ret.putScalar(i.get(), nd.getDouble(j));
                    }
                    i.incrementAndGet();
                }
            });
        }
        return ret;
    }

    @Override
    public INDArray vstack(INDArray ... arrs) {
        int cols = arrs[0].columns();
        int rows = arrs[0].rows();
        for (int i = 1; i < arrs.length; ++i) {
            rows += arrs[i].rows();
            if (arrs[i].columns() == cols) continue;
            throw new IllegalStateException("Illegal number of rows for array " + i);
        }
        final INDArray ret = Nd4j.create(rows, cols);
        final AtomicInteger i = new AtomicInteger(0);
        for (INDArray arr : arrs) {
            arr.iterateOverAllRows(new SliceOp(){

                @Override
                public void operate(DimensionSlice nd) {
                }

                @Override
                public void operate(INDArray nd) {
                    ret.putRow(i.get(), nd);
                    i.incrementAndGet();
                }
            });
        }
        return ret;
    }

    @Override
    public INDArray zeros(int[] shape) {
        INDArray ret = this.create(shape);
        return ret;
    }

    @Override
    public IComplexNDArray complexZeros(int[] shape) {
        IComplexNDArray ret = this.createComplex(shape);
        return ret;
    }

    @Override
    public INDArray ones(int[] shape) {
        INDArray ret = this.create(shape);
        ret.assign(1);
        return ret;
    }

    @Override
    public IComplexNDArray complexOnes(int[] shape) {
        IComplexNDArray ret = this.createComplex(shape);
        ret.assign(1);
        return ret;
    }

    @Override
    public IComplexNDArray createComplex(float[] data, int rows, int columns, int[] stride, int offset) {
        return this.createComplex(data, new int[]{rows, columns}, stride, offset);
    }

    @Override
    public INDArray create(float[] data, int rows, int columns, int[] stride, int offset) {
        return this.create(data, new int[]{rows, columns}, stride, offset);
    }

    @Override
    public abstract IComplexNDArray createComplex(float[] var1, int[] var2, int[] var3, int var4);

    @Override
    public abstract INDArray create(float[] var1, int[] var2, int[] var3, int var4);

    @Override
    public INDArray create(double[] data, int[] shape) {
        return this.create(data, shape, Nd4j.getStrides(shape), 0);
    }

    @Override
    public INDArray create(float[] data, int[] shape) {
        return this.create(data, shape, Nd4j.getStrides(shape), 0);
    }

    @Override
    public IComplexNDArray createComplex(double[] data, int[] shape) {
        return this.createComplex(data, shape, Nd4j.getComplexStrides(shape), 0);
    }

    @Override
    public IComplexNDArray createComplex(float[] data, int[] shape) {
        return this.createComplex(data, shape, Nd4j.getComplexStrides(shape), 0);
    }

    @Override
    public IComplexNDArray createComplex(double[] data, int[] shape, int[] stride) {
        return this.createComplex(data, shape, stride, 0);
    }

    @Override
    public IComplexNDArray createComplex(float[] data, int[] shape, int[] stride) {
        return this.createComplex(data, shape, stride, 0);
    }

    @Override
    public IComplexNDArray createComplex(double[] data, int rows, int columns, int[] stride, int offset) {
        return this.createComplex(data, new int[]{rows, columns}, stride, offset);
    }

    @Override
    public INDArray create(double[] data, int rows, int columns, int[] stride, int offset) {
        return this.create(data, new int[]{rows, columns}, stride, offset);
    }

    @Override
    public abstract IComplexNDArray createComplex(double[] var1, int[] var2, int[] var3, int var4);

    @Override
    public abstract INDArray create(double[] var1, int[] var2, int[] var3, int var4);

    @Override
    public abstract INDArray create(List<INDArray> var1, int[] var2);

    @Override
    public IComplexNDArray createComplex(int rows, int columns, int[] stride, int offset) {
        if (this.dtype.equals("double")) {
            return this.createComplex(new double[rows * columns * 2], new int[]{rows, columns}, stride, offset);
        }
        if (this.dtype.equals("float")) {
            return this.createComplex(new float[rows * columns * 2], new int[]{rows, columns}, stride, offset);
        }
        throw new IllegalStateException("Illegal data type " + this.dtype);
    }

    @Override
    public INDArray create(int rows, int columns, int[] stride, int offset) {
        if (this.dtype.equals("double")) {
            return this.create(new double[rows * columns], new int[]{rows, columns}, stride, offset);
        }
        if (this.dtype.equals("float")) {
            return this.create(new float[rows * columns], new int[]{rows, columns}, stride, offset);
        }
        throw new IllegalStateException("Illegal data type " + this.dtype);
    }

    @Override
    public IComplexNDArray createComplex(int[] shape, int[] stride, int offset) {
        if (this.dtype.equals("double")) {
            return this.createComplex(new double[ArrayUtil.prod(shape) * 2], shape, stride, offset);
        }
        if (this.dtype.equals("float")) {
            return this.createComplex(new float[ArrayUtil.prod(shape) * 2], shape, stride, offset);
        }
        throw new IllegalStateException("Illegal data type " + this.dtype);
    }

    @Override
    public INDArray create(int[] shape, int[] stride, int offset) {
        return this.create(Nd4j.createBuffer(shape), shape, stride, offset);
    }

    @Override
    public IComplexNDArray createComplex(int rows, int columns, int[] stride) {
        return this.createComplex(new int[]{rows, columns}, stride);
    }

    @Override
    public INDArray create(int rows, int columns, int[] stride) {
        return this.create(new int[]{rows, columns}, stride);
    }

    @Override
    public IComplexNDArray createComplex(int[] shape, int[] stride) {
        return this.createComplex(shape, stride, 0);
    }

    @Override
    public INDArray create(int[] shape, int[] stride) {
        return this.create(shape, stride, 0);
    }

    @Override
    public IComplexNDArray createComplex(int rows, int columns) {
        return this.createComplex(new int[]{rows, columns});
    }

    @Override
    public INDArray create(int rows, int columns) {
        return this.create(new int[]{rows, columns});
    }

    @Override
    public IComplexNDArray createComplex(int[] shape) {
        return this.createComplex(shape, Nd4j.getComplexStrides(shape), 0);
    }

    @Override
    public INDArray create(int[] shape) {
        return this.create(shape, Nd4j.getStrides(shape), 0);
    }

    @Override
    public INDArray scalar(Number value, int offset) {
        if (this.dtype.equals("double")) {
            return this.scalar(value.doubleValue(), offset);
        }
        if (this.dtype.equals("float")) {
            return this.scalar(value.floatValue(), offset);
        }
        throw new IllegalStateException("Illegal data type " + this.dtype);
    }

    @Override
    public IComplexNDArray complexScalar(Number value, int offset) {
        if (this.dtype.equals("double")) {
            return this.scalar(this.createDouble(value.doubleValue(), 0.0), offset);
        }
        if (this.dtype.equals("float")) {
            return this.scalar(this.createFloat(value.floatValue(), 0.0f), offset);
        }
        throw new IllegalStateException("Illegal data type " + this.dtype);
    }

    @Override
    public IComplexNDArray complexScalar(Number value) {
        return this.complexScalar(value, 0);
    }

    @Override
    public INDArray scalar(float value, int offset) {
        return this.create(new float[]{value}, new int[]{1}, new int[]{1}, offset);
    }

    @Override
    public INDArray scalar(double value, int offset) {
        return this.create(new double[]{value}, new int[]{1}, new int[]{1}, offset);
    }

    @Override
    public INDArray scalar(Number value) {
        if (this.dtype.equals("double")) {
            return this.scalar(value.doubleValue(), 0);
        }
        if (this.dtype.equals("float")) {
            return this.scalar(value.floatValue(), 0);
        }
        throw new IllegalStateException("Illegal data type " + this.dtype);
    }

    @Override
    public INDArray scalar(float value) {
        if (this.dtype.equals("float")) {
            return this.create(new float[]{value}, new int[]{1}, new int[]{1}, 0);
        }
        return this.scalar((double)value);
    }

    @Override
    public INDArray scalar(double value) {
        if (this.dtype.equals("double")) {
            return this.create(new double[]{value}, new int[]{1}, new int[]{1}, 0);
        }
        return this.scalar((float)value);
    }

    @Override
    public IComplexNDArray scalar(IComplexNumber value, int offset) {
        if (this.dtype.equals("double")) {
            return this.scalar(value.asDouble(), offset);
        }
        if (this.dtype.equals("float")) {
            return this.scalar(value.asFloat(), offset);
        }
        throw new IllegalStateException("Illegal data type " + this.dtype);
    }

    @Override
    public IComplexNDArray scalar(IComplexFloat value) {
        return this.createComplex(new float[]{value.realComponent().floatValue(), value.imaginaryComponent().floatValue()}, new int[]{1}, new int[]{1}, 0);
    }

    @Override
    public IComplexNDArray scalar(IComplexDouble value) {
        return this.createComplex(new double[]{value.realComponent(), value.imaginaryComponent()}, new int[]{1}, new int[]{1}, 0);
    }

    @Override
    public IComplexNDArray scalar(IComplexNumber value) {
        if (this.dtype.equals("double")) {
            return this.scalar(value.asDouble(), 0);
        }
        if (this.dtype.equals("float")) {
            return this.scalar(value.asFloat(), 0);
        }
        throw new IllegalStateException("Illegal data type " + this.dtype);
    }

    @Override
    public IComplexNDArray scalar(IComplexFloat value, int offset) {
        return this.createComplex(new float[]{value.realComponent().floatValue(), value.imaginaryComponent().floatValue()}, new int[]{1}, new int[]{1}, offset);
    }

    @Override
    public IComplexNDArray scalar(IComplexDouble value, int offset) {
        return this.createComplex(new double[]{value.realComponent(), value.imaginaryComponent()}, new int[]{1}, new int[]{1}, offset);
    }

    @Override
    public abstract IComplexNDArray createComplex(double[] var1, int[] var2, int[] var3, int var4, char var5);

    @Override
    public IComplexNDArray createComplex(double[] data, int[] shape, int offset, char ordering) {
        return this.createComplex(Nd4j.createBuffer(data), shape, offset, ordering);
    }

    @Override
    public IComplexNDArray createComplex(double[] data, int[] shape, int offset) {
        return this.createComplex(Nd4j.createBuffer(data), shape, offset);
    }

    @Override
    public INDArray create(float[] data, int[] shape, int offset) {
        return this.create(Nd4j.createBuffer(data), shape, offset);
    }
}

