/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.ops;

import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.ops.BaseTwoArrayElementWiseOp;

public class TwoArrayOps {
    private INDArray from;
    private INDArray to;
    private INDArray other;
    private Object scalar;
    private Class<? extends BaseTwoArrayElementWiseOp> clazz;

    public TwoArrayOps op(Class<? extends BaseTwoArrayElementWiseOp> clazz) {
        this.clazz = clazz;
        return this;
    }

    public TwoArrayOps other(INDArray other) {
        this.other = other;
        return this;
    }

    public TwoArrayOps from(INDArray from) {
        this.from = from;
        return this;
    }

    public TwoArrayOps to(INDArray to) {
        this.to = to;
        return this;
    }

    public TwoArrayOps scalar(Object scalar) {
        if (scalar instanceof Number) {
            Number n = (Number)scalar;
            this.scalar = Float.valueOf(n.floatValue());
        } else if (scalar instanceof INDArray) {
            INDArray a = (INDArray)scalar;
            if (!a.isScalar()) {
                throw new IllegalArgumentException("Only scalar nd arrays allowed");
            }
            Float n = Float.valueOf(a.get(0));
            this.scalar = Float.valueOf(((Number)n).floatValue());
        } else {
            throw new IllegalArgumentException("Illegal type passed in: Only ndarrays and scalars allowed");
        }
        return this;
    }

    public BaseTwoArrayElementWiseOp build() {
        try {
            BaseTwoArrayElementWiseOp op = this.clazz.newInstance();
            op.from = this.from;
            op.to = this.to;
            op.other = this.other;
            op.scalarValue = this.scalar;
            return op;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

