/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.shade.jackson.dataformat.xml;

import java.io.IOException;
import java.util.Collection;
import org.nd4j.shade.jackson.annotation.JsonTypeInfo;
import org.nd4j.shade.jackson.databind.DatabindContext;
import org.nd4j.shade.jackson.databind.JavaType;
import org.nd4j.shade.jackson.databind.cfg.MapperConfig;
import org.nd4j.shade.jackson.databind.jsontype.NamedType;
import org.nd4j.shade.jackson.databind.jsontype.TypeIdResolver;
import org.nd4j.shade.jackson.databind.jsontype.impl.ClassNameIdResolver;
import org.nd4j.shade.jackson.databind.jsontype.impl.MinimalClassNameIdResolver;
import org.nd4j.shade.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import org.nd4j.shade.jackson.databind.type.TypeFactory;
import org.nd4j.shade.jackson.dataformat.xml.util.StaxUtil;

public class XmlTypeResolverBuilder
extends StdTypeResolverBuilder {
    @Override
    public StdTypeResolverBuilder init(JsonTypeInfo.Id idType, TypeIdResolver idRes) {
        super.init(idType, idRes);
        if (this._typeProperty != null) {
            this._typeProperty = StaxUtil.sanitizeXmlTypeName(this._typeProperty);
        }
        return this;
    }

    @Override
    public StdTypeResolverBuilder typeProperty(String typeIdPropName) {
        if (typeIdPropName == null || typeIdPropName.length() == 0) {
            typeIdPropName = this._idType.getDefaultPropertyName();
        }
        this._typeProperty = StaxUtil.sanitizeXmlTypeName(typeIdPropName);
        return this;
    }

    @Override
    protected TypeIdResolver idResolver(MapperConfig<?> config, JavaType baseType, Collection<NamedType> subtypes, boolean forSer, boolean forDeser) {
        if (this._customIdResolver != null) {
            return this._customIdResolver;
        }
        switch (this._idType) {
            case CLASS: {
                return new XmlClassNameIdResolver(baseType, config.getTypeFactory());
            }
            case MINIMAL_CLASS: {
                return new XmlMinimalClassNameIdResolver(baseType, config.getTypeFactory());
            }
        }
        return super.idResolver(config, baseType, subtypes, forSer, forDeser);
    }

    protected static String encodeXmlClassName(String className) {
        int ix = className.lastIndexOf(36);
        if (ix >= 0) {
            StringBuilder sb = new StringBuilder(className);
            do {
                sb.replace(ix, ix + 1, "..");
            } while ((ix = className.lastIndexOf(36, ix - 1)) >= 0);
            className = sb.toString();
        }
        return className;
    }

    protected static String decodeXmlClassName(String className) {
        int ix = className.lastIndexOf("..");
        if (ix >= 0) {
            StringBuilder sb = new StringBuilder(className);
            do {
                sb.replace(ix, ix + 2, "$");
            } while ((ix = className.lastIndexOf("..", ix - 1)) >= 0);
            className = sb.toString();
        }
        return className;
    }

    protected static class XmlMinimalClassNameIdResolver
    extends MinimalClassNameIdResolver {
        public XmlMinimalClassNameIdResolver(JavaType baseType, TypeFactory typeFactory) {
            super(baseType, typeFactory);
        }

        @Override
        public String idFromValue(Object value) {
            return XmlTypeResolverBuilder.encodeXmlClassName(super.idFromValue(value));
        }

        @Override
        public JavaType typeFromId(DatabindContext context, String id) throws IOException {
            return super.typeFromId(context, XmlTypeResolverBuilder.decodeXmlClassName(id));
        }
    }

    protected static class XmlClassNameIdResolver
    extends ClassNameIdResolver {
        public XmlClassNameIdResolver(JavaType baseType, TypeFactory typeFactory) {
            super(baseType, typeFactory);
        }

        @Override
        public String idFromValue(Object value) {
            return XmlTypeResolverBuilder.encodeXmlClassName(super.idFromValue(value));
        }

        @Override
        public JavaType typeFromId(DatabindContext context, String id) throws IOException {
            return super.typeFromId(context, XmlTypeResolverBuilder.decodeXmlClassName(id));
        }
    }
}

