/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.shade.jackson.datatype.joda.deser;

import java.io.IOException;
import org.joda.time.LocalTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.nd4j.shade.jackson.core.JsonParser;
import org.nd4j.shade.jackson.core.JsonToken;
import org.nd4j.shade.jackson.databind.DeserializationContext;
import org.nd4j.shade.jackson.datatype.joda.deser.JodaDeserializerBase;

public class LocalTimeDeserializer
extends JodaDeserializerBase<LocalTime> {
    private static final long serialVersionUID = 1L;
    static final DateTimeFormatter parser = ISODateTimeFormat.localTimeParser();

    public LocalTimeDeserializer() {
        super(LocalTime.class);
    }

    @Override
    public LocalTime deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        switch (jp.getCurrentToken()) {
            case START_ARRAY: {
                if (!jp.isExpectedStartArrayToken()) break;
                jp.nextToken();
                int hour = jp.getIntValue();
                jp.nextToken();
                int minute = jp.getIntValue();
                jp.nextToken();
                int second = jp.getIntValue();
                jp.nextToken();
                int millis = 0;
                if (jp.getCurrentToken() != JsonToken.END_ARRAY) {
                    millis = jp.getIntValue();
                    jp.nextToken();
                }
                if (jp.getCurrentToken() != JsonToken.END_ARRAY) {
                    throw ctxt.wrongTokenException(jp, JsonToken.END_ARRAY, "after LocalTime ints");
                }
                return new LocalTime(hour, minute, second, millis);
            }
            case VALUE_NUMBER_INT: {
                return new LocalTime(jp.getLongValue());
            }
            case VALUE_STRING: {
                String str = jp.getText().trim();
                if (str.length() == 0) {
                    return null;
                }
                return parser.parseLocalTime(str);
            }
        }
        throw ctxt.wrongTokenException(jp, JsonToken.START_ARRAY, "expected JSON Array, String or Number");
    }
}

