/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.shade.jackson.datatype.joda.ser;

import java.io.IOException;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;
import org.nd4j.shade.jackson.core.JsonGenerator;
import org.nd4j.shade.jackson.databind.SerializationFeature;
import org.nd4j.shade.jackson.databind.SerializerProvider;
import org.nd4j.shade.jackson.datatype.joda.cfg.FormatConfig;
import org.nd4j.shade.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import org.nd4j.shade.jackson.datatype.joda.ser.JodaDateSerializerBase;

public final class LocalDateTimeSerializer
extends JodaDateSerializerBase<LocalDateTime> {
    private static final long serialVersionUID = 1L;

    public LocalDateTimeSerializer() {
        this(FormatConfig.DEFAULT_LOCAL_DATETIME_FORMAT);
    }

    public LocalDateTimeSerializer(JacksonJodaDateFormat format) {
        super(LocalDateTime.class, format, true, SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
    }

    public LocalDateTimeSerializer withFormat(JacksonJodaDateFormat formatter) {
        return this._format == formatter ? this : new LocalDateTimeSerializer(formatter);
    }

    @Override
    public void serialize(LocalDateTime value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (this._useTimestamp(provider)) {
            jgen.writeStartArray();
            jgen.writeNumber(value.year().get());
            jgen.writeNumber(value.monthOfYear().get());
            jgen.writeNumber(value.dayOfMonth().get());
            jgen.writeNumber(value.hourOfDay().get());
            jgen.writeNumber(value.minuteOfHour().get());
            jgen.writeNumber(value.secondOfMinute().get());
            jgen.writeNumber(value.millisOfSecond().get());
            jgen.writeEndArray();
        } else {
            jgen.writeString(this._format.createFormatter(provider).print((ReadablePartial)value));
        }
    }
}

