/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.shade.jackson.databind.ser.impl;

import java.io.IOException;
import java.util.Collection;
import org.nd4j.shade.jackson.core.JsonGenerationException;
import org.nd4j.shade.jackson.core.JsonGenerator;
import org.nd4j.shade.jackson.databind.BeanProperty;
import org.nd4j.shade.jackson.databind.JsonMappingException;
import org.nd4j.shade.jackson.databind.JsonNode;
import org.nd4j.shade.jackson.databind.JsonSerializer;
import org.nd4j.shade.jackson.databind.SerializationFeature;
import org.nd4j.shade.jackson.databind.SerializerProvider;
import org.nd4j.shade.jackson.databind.annotation.JacksonStdImpl;
import org.nd4j.shade.jackson.databind.introspect.AnnotatedMember;
import org.nd4j.shade.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import org.nd4j.shade.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import org.nd4j.shade.jackson.databind.jsontype.TypeSerializer;
import org.nd4j.shade.jackson.databind.ser.ContextualSerializer;
import org.nd4j.shade.jackson.databind.ser.std.StaticListSerializerBase;

@JacksonStdImpl
public class StringCollectionSerializer
extends StaticListSerializerBase<Collection<String>>
implements ContextualSerializer {
    public static final StringCollectionSerializer instance = new StringCollectionSerializer();
    protected final JsonSerializer<String> _serializer;

    protected StringCollectionSerializer() {
        this((JsonSerializer<?>)null);
    }

    protected StringCollectionSerializer(JsonSerializer<?> ser) {
        super(Collection.class);
        this._serializer = ser;
    }

    @Override
    protected JsonNode contentSchema() {
        return this.createSchemaNode("string", true);
    }

    @Override
    protected void acceptContentVisitor(JsonArrayFormatVisitor visitor) throws JsonMappingException {
        visitor.itemsFormat(JsonFormatTypes.STRING);
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        Object serDef;
        AnnotatedMember m;
        JsonSerializer<Object> ser = null;
        if (property != null && (m = property.getMember()) != null && (serDef = provider.getAnnotationIntrospector().findContentSerializer(m)) != null) {
            ser = provider.serializerInstance(m, serDef);
        }
        if (ser == null) {
            ser = this._serializer;
        }
        if (this.isDefaultSerializer(ser = (ser = this.findConvertingContentSerializer(provider, property, ser)) == null ? provider.findValueSerializer(String.class, property) : provider.handleSecondaryContextualization(ser, property))) {
            ser = null;
        }
        if (ser == this._serializer) {
            return this;
        }
        return new StringCollectionSerializer(ser);
    }

    @Override
    public void serialize(Collection<String> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        int len = value.size();
        if (len == 1 && provider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED)) {
            this._serializeUnwrapped(value, jgen, provider);
            return;
        }
        jgen.writeStartArray(len);
        if (this._serializer == null) {
            this.serializeContents(value, jgen, provider);
        } else {
            this.serializeUsingCustom(value, jgen, provider);
        }
        jgen.writeEndArray();
    }

    private final void _serializeUnwrapped(Collection<String> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        if (this._serializer == null) {
            this.serializeContents(value, jgen, provider);
        } else {
            this.serializeUsingCustom(value, jgen, provider);
        }
    }

    @Override
    public void serializeWithType(Collection<String> value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonGenerationException {
        typeSer.writeTypePrefixForArray(value, jgen);
        if (this._serializer == null) {
            this.serializeContents(value, jgen, provider);
        } else {
            this.serializeUsingCustom(value, jgen, provider);
        }
        typeSer.writeTypeSuffixForArray(value, jgen);
    }

    private final void serializeContents(Collection<String> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        if (this._serializer != null) {
            this.serializeUsingCustom(value, jgen, provider);
            return;
        }
        int i = 0;
        for (String str : value) {
            try {
                if (str == null) {
                    provider.defaultSerializeNull(jgen);
                } else {
                    jgen.writeString(str);
                }
                ++i;
            }
            catch (Exception e) {
                this.wrapAndThrow(provider, (Throwable)e, value, i);
            }
        }
    }

    private void serializeUsingCustom(Collection<String> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        JsonSerializer<String> ser = this._serializer;
        int i = 0;
        for (String str : value) {
            try {
                if (str == null) {
                    provider.defaultSerializeNull(jgen);
                    continue;
                }
                ser.serialize(str, jgen, provider);
            }
            catch (Exception e) {
                this.wrapAndThrow(provider, (Throwable)e, value, i);
            }
        }
    }
}

