/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.shade.jackson.datatype.joda.deser;

import java.io.IOException;
import org.joda.time.DateTimeZone;
import org.nd4j.shade.jackson.core.JsonParser;
import org.nd4j.shade.jackson.core.JsonToken;
import org.nd4j.shade.jackson.databind.DeserializationContext;
import org.nd4j.shade.jackson.datatype.joda.deser.JodaDeserializerBase;

public class DateTimeZoneDeserializer
extends JodaDeserializerBase<DateTimeZone> {
    private static final long serialVersionUID = 1L;

    public DateTimeZoneDeserializer() {
        super(DateTimeZone.class);
    }

    @Override
    public DateTimeZone deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT) {
            return DateTimeZone.forOffsetHours((int)jp.getIntValue());
        }
        if (t == JsonToken.VALUE_STRING) {
            return DateTimeZone.forID((String)jp.getText().trim());
        }
        throw ctxt.mappingException(DateTimeZone.class, JsonToken.VALUE_STRING);
    }
}

