/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.statement;

import com.ibatis.sqlmap.client.event.RowHandler;
import com.ibatis.sqlmap.engine.cache.CacheKey;
import com.ibatis.sqlmap.engine.cache.CacheModel;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMap;
import com.ibatis.sqlmap.engine.mapping.result.ResultMap;
import com.ibatis.sqlmap.engine.mapping.sql.Sql;
import com.ibatis.sqlmap.engine.mapping.statement.ExecuteListener;
import com.ibatis.sqlmap.engine.mapping.statement.MappedStatement;
import com.ibatis.sqlmap.engine.mapping.statement.StatementType;
import com.ibatis.sqlmap.engine.scope.StatementScope;
import com.ibatis.sqlmap.engine.transaction.Transaction;
import java.sql.SQLException;
import java.util.List;

public class CachingStatement
extends MappedStatement {
    private MappedStatement statement;
    private CacheModel cacheModel;

    public CachingStatement(MappedStatement statement, CacheModel cacheModel) {
        this.statement = statement;
        this.cacheModel = cacheModel;
    }

    @Override
    public String getId() {
        return this.statement.getId();
    }

    @Override
    public StatementType getStatementType() {
        return this.statement.getStatementType();
    }

    @Override
    public Integer getResultSetType() {
        return this.statement.getResultSetType();
    }

    @Override
    public Integer getFetchSize() {
        return this.statement.getFetchSize();
    }

    @Override
    public ParameterMap getParameterMap() {
        return this.statement.getParameterMap();
    }

    @Override
    public ResultMap getResultMap() {
        return this.statement.getResultMap();
    }

    @Override
    public int executeUpdate(StatementScope statementScope, Transaction trans, Object parameterObject) throws SQLException {
        int n = this.statement.executeUpdate(statementScope, trans, parameterObject);
        return n;
    }

    @Override
    public Object executeQueryForObject(StatementScope statementScope, Transaction trans, Object parameterObject, Object resultObject) throws SQLException {
        CacheKey cacheKey = this.getCacheKey(statementScope, parameterObject);
        cacheKey.update("executeQueryForObject");
        Object object = this.cacheModel.getObject(cacheKey);
        if (object == CacheModel.NULL_OBJECT) {
            object = null;
        } else if (object == null) {
            object = this.statement.executeQueryForObject(statementScope, trans, parameterObject, resultObject);
            this.cacheModel.putObject(cacheKey, object);
        }
        return object;
    }

    @Override
    public List executeQueryForList(StatementScope statementScope, Transaction trans, Object parameterObject, int skipResults, int maxResults) throws SQLException {
        List list;
        CacheKey cacheKey = this.getCacheKey(statementScope, parameterObject);
        cacheKey.update("executeQueryForList");
        cacheKey.update(skipResults);
        cacheKey.update(maxResults);
        Object listAsObject = this.cacheModel.getObject(cacheKey);
        if (listAsObject == CacheModel.NULL_OBJECT) {
            list = null;
        } else if (listAsObject == null) {
            list = this.statement.executeQueryForList(statementScope, trans, parameterObject, skipResults, maxResults);
            this.cacheModel.putObject(cacheKey, list);
        } else {
            list = (List)listAsObject;
        }
        return list;
    }

    @Override
    public void executeQueryWithRowHandler(StatementScope statementScope, Transaction trans, Object parameterObject, RowHandler rowHandler) throws SQLException {
        this.statement.executeQueryWithRowHandler(statementScope, trans, parameterObject, rowHandler);
    }

    @Override
    public CacheKey getCacheKey(StatementScope statementScope, Object parameterObject) {
        CacheKey key = this.statement.getCacheKey(statementScope, parameterObject);
        if (!this.cacheModel.isReadOnly() && !this.cacheModel.isSerialize()) {
            key.update(statementScope.getSession());
        }
        return key;
    }

    @Override
    public void setBaseCacheKey(int base) {
        this.statement.setBaseCacheKey(base);
    }

    @Override
    public void addExecuteListener(ExecuteListener listener) {
        this.statement.addExecuteListener(listener);
    }

    @Override
    public void notifyListeners() {
        this.statement.notifyListeners();
    }

    @Override
    public void initRequest(StatementScope statementScope) {
        this.statement.initRequest(statementScope);
    }

    @Override
    public Sql getSql() {
        return this.statement.getSql();
    }

    @Override
    public Class getParameterClass() {
        return this.statement.getParameterClass();
    }

    @Override
    public Integer getTimeout() {
        return this.statement.getTimeout();
    }

    @Override
    public boolean hasMultipleResultMaps() {
        return this.statement.hasMultipleResultMaps();
    }

    @Override
    public ResultMap[] getAdditionalResultMaps() {
        return this.statement.getAdditionalResultMaps();
    }
}

