/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.common.resources;

import com.ibatis.common.beans.ClassInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Properties;

public class Resources {
    private static ClassLoader defaultClassLoader;
    private static Charset charset;

    private Resources() {
    }

    public static ClassLoader getDefaultClassLoader() {
        return defaultClassLoader;
    }

    public static void setDefaultClassLoader(ClassLoader defaultClassLoader) {
        Resources.defaultClassLoader = defaultClassLoader;
    }

    public static URL getResourceURL(String resource) throws IOException {
        return Resources.getResourceURL(Resources.getClassLoader(), resource);
    }

    public static URL getResourceURL(ClassLoader loader, String resource) throws IOException {
        URL url = null;
        if (loader != null) {
            url = loader.getResource(resource);
        }
        if (url == null) {
            url = ClassLoader.getSystemResource(resource);
        }
        if (url == null) {
            throw new IOException("Could not find resource " + resource);
        }
        return url;
    }

    public static InputStream getResourceAsStream(String resource) throws IOException {
        return Resources.getResourceAsStream(Resources.getClassLoader(), resource);
    }

    public static InputStream getResourceAsStream(ClassLoader loader, String resource) throws IOException {
        InputStream in = null;
        if (loader != null) {
            in = loader.getResourceAsStream(resource);
        }
        if (in == null) {
            in = ClassLoader.getSystemResourceAsStream(resource);
        }
        if (in == null) {
            throw new IOException("Could not find resource " + resource);
        }
        return in;
    }

    public static Properties getResourceAsProperties(String resource) throws IOException {
        Properties props = new Properties();
        InputStream in = null;
        String propfile = resource;
        in = Resources.getResourceAsStream(propfile);
        props.load(in);
        in.close();
        return props;
    }

    public static Properties getResourceAsProperties(ClassLoader loader, String resource) throws IOException {
        Properties props = new Properties();
        InputStream in = null;
        String propfile = resource;
        in = Resources.getResourceAsStream(loader, propfile);
        props.load(in);
        in.close();
        return props;
    }

    public static Reader getResourceAsReader(String resource) throws IOException {
        InputStreamReader reader = charset == null ? new InputStreamReader(Resources.getResourceAsStream(resource)) : new InputStreamReader(Resources.getResourceAsStream(resource), charset);
        return reader;
    }

    public static Reader getResourceAsReader(ClassLoader loader, String resource) throws IOException {
        InputStreamReader reader = charset == null ? new InputStreamReader(Resources.getResourceAsStream(loader, resource)) : new InputStreamReader(Resources.getResourceAsStream(loader, resource), charset);
        return reader;
    }

    public static File getResourceAsFile(String resource) throws IOException {
        return Path.of(Resources.getResourceURL(resource).toString(), new String[0]).toFile();
    }

    public static File getResourceAsFile(ClassLoader loader, String resource) throws IOException {
        return Path.of(Resources.getResourceURL(loader, resource).toString(), new String[0]).toFile();
    }

    public static InputStream getUrlAsStream(String urlString) throws IOException {
        URL url = new URL(urlString);
        URLConnection conn = url.openConnection();
        return conn.getInputStream();
    }

    public static Reader getUrlAsReader(String urlString) throws IOException {
        return new InputStreamReader(Resources.getUrlAsStream(urlString));
    }

    public static Properties getUrlAsProperties(String urlString) throws IOException {
        Properties props = new Properties();
        InputStream in = null;
        String propfile = urlString;
        in = Resources.getUrlAsStream(propfile);
        props.load(in);
        in.close();
        return props;
    }

    public static Class classForName(String className) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            clazz = Resources.getClassLoader().loadClass(className);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (clazz == null) {
            clazz = Class.forName(className);
        }
        return clazz;
    }

    public static Object instantiate(String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return Resources.instantiate(Resources.classForName(className));
    }

    public static Object instantiate(Class clazz) throws InstantiationException, IllegalAccessException {
        try {
            return ClassInfo.getInstance(clazz).instantiateClass();
        }
        catch (Exception e) {
            return clazz.newInstance();
        }
    }

    private static ClassLoader getClassLoader() {
        if (defaultClassLoader != null) {
            return defaultClassLoader;
        }
        return Thread.currentThread().getContextClassLoader();
    }

    public static Charset getCharset() {
        return charset;
    }

    public static void setCharset(Charset charset) {
        Resources.charset = charset;
    }
}

