/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.common.beans;

import com.ibatis.common.beans.BaseProbe;
import com.ibatis.common.beans.ProbeException;
import com.ibatis.common.resources.Resources;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DomProbe
extends BaseProbe {
    @Override
    public String[] getReadablePropertyNames(Object object) {
        ArrayList<String> props = new ArrayList<String>();
        Element e = this.resolveElement(object);
        NodeList nodes = e.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            props.add(nodes.item(i).getNodeName());
        }
        return props.toArray(new String[props.size()]);
    }

    @Override
    public String[] getWriteablePropertyNames(Object object) {
        ArrayList<String> props = new ArrayList<String>();
        Element e = this.resolveElement(object);
        NodeList nodes = e.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            props.add(nodes.item(i).getNodeName());
        }
        return props.toArray(new String[props.size()]);
    }

    @Override
    public Class getPropertyTypeForSetter(Object object, String name) {
        Element e = this.findNestedNodeByName(this.resolveElement(object), name, false);
        try {
            return Resources.classForName(e.getAttribute("type"));
        }
        catch (ClassNotFoundException e1) {
            return Object.class;
        }
    }

    @Override
    public Class getPropertyTypeForGetter(Object object, String name) {
        Element e = this.findNestedNodeByName(this.resolveElement(object), name, false);
        try {
            return Resources.classForName(e.getAttribute("type"));
        }
        catch (ClassNotFoundException e1) {
            return Object.class;
        }
    }

    @Override
    public boolean hasWritableProperty(Object object, String propertyName) {
        return this.findNestedNodeByName(this.resolveElement(object), propertyName, false) != null;
    }

    @Override
    public boolean hasReadableProperty(Object object, String propertyName) {
        return this.findNestedNodeByName(this.resolveElement(object), propertyName, false) != null;
    }

    @Override
    public Object getObject(Object object, String name) {
        Object value = null;
        Element element = this.findNestedNodeByName(this.resolveElement(object), name, false);
        if (element != null) {
            value = this.getElementValue(element);
        }
        return value;
    }

    @Override
    public void setObject(Object object, String name, Object value) {
        Element element = this.findNestedNodeByName(this.resolveElement(object), name, true);
        if (element != null) {
            this.setElementValue(element, value);
        }
    }

    @Override
    protected void setProperty(Object object, String property, Object value) {
        Element element = this.findNodeByName(this.resolveElement(object), property, 0, true);
        if (element != null) {
            this.setElementValue(element, value);
        }
    }

    @Override
    protected Object getProperty(Object object, String property) {
        Object value = null;
        Element element = this.findNodeByName(this.resolveElement(object), property, 0, false);
        if (element != null) {
            value = this.getElementValue(element);
        }
        return value;
    }

    private Element resolveElement(Object object) {
        Element element = null;
        if (object instanceof Document) {
            element = (Element)((Document)object).getLastChild();
        } else if (object instanceof Element) {
            element = (Element)object;
        } else {
            throw new ProbeException("An unknown object type was passed to DomProbe.  Must be a Document.");
        }
        return element;
    }

    private void setElementValue(Element element, Object value) {
        CharacterData data = null;
        Element prop = element;
        if (value instanceof Collection) {
            for (Document valdoc : (Collection)value) {
                NodeList list = valdoc.getChildNodes();
                for (int i = 0; i < list.getLength(); ++i) {
                    Node newNode = element.getOwnerDocument().importNode(list.item(i), true);
                    element.appendChild(newNode);
                }
            }
        } else if (value instanceof Document) {
            Document valdoc = (Document)value;
            Node lastChild = valdoc.getLastChild();
            NodeList list = lastChild.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node newNode = element.getOwnerDocument().importNode(list.item(i), true);
                element.appendChild(newNode);
            }
        } else if (value instanceof Element) {
            Node newNode = element.getOwnerDocument().importNode((Element)value, true);
            element.appendChild(newNode);
        } else {
            NodeList texts = prop.getChildNodes();
            if (texts.getLength() == 1) {
                Node child = texts.item(0);
                if (child instanceof CharacterData) {
                    data = (CharacterData)child;
                } else {
                    prop.removeChild(child);
                    Text text = prop.getOwnerDocument().createTextNode(String.valueOf(value));
                    prop.appendChild(text);
                    data = text;
                }
            } else if (texts.getLength() > 1) {
                for (int i = texts.getLength() - 1; i >= 0; --i) {
                    prop.removeChild(texts.item(i));
                }
                Text text = prop.getOwnerDocument().createTextNode(String.valueOf(value));
                prop.appendChild(text);
                data = text;
            } else {
                Text text = prop.getOwnerDocument().createTextNode(String.valueOf(value));
                prop.appendChild(text);
                data = text;
            }
            data.setData(String.valueOf(value));
        }
    }

    private Object getElementValue(Element element) {
        NodeList texts;
        StringBuilder value = null;
        Element prop = element;
        if (prop != null && (texts = prop.getChildNodes()).getLength() > 0) {
            value = new StringBuilder();
            for (int i = 0; i < texts.getLength(); ++i) {
                Node text = texts.item(i);
                if (!(text instanceof CharacterData)) continue;
                value.append(((CharacterData)text).getData());
            }
        }
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    private Element findNestedNodeByName(Element element, String name, boolean create) {
        Element child = element;
        StringTokenizer parser = new StringTokenizer(name, ".", false);
        while (parser.hasMoreTokens()) {
            String childName = parser.nextToken();
            if (childName.indexOf(91) > -1) {
                String propName = childName.substring(0, childName.indexOf(91));
                int i = Integer.parseInt(childName.substring(childName.indexOf(91) + 1, childName.indexOf(93)));
                child = this.findNodeByName(child, propName, i, create);
            } else {
                child = this.findNodeByName(child, childName, 0, create);
            }
            if (child != null) continue;
            break;
        }
        return child;
    }

    private Element findNodeByName(Element element, String name, int index, boolean create) {
        Element prop = null;
        NodeList propNodes = element.getElementsByTagName(name);
        if (propNodes.getLength() > index) {
            prop = (Element)propNodes.item(index);
        } else if (create) {
            for (int i = 0; i < index + 1; ++i) {
                prop = element.getOwnerDocument().createElement(name);
                element.appendChild(prop);
            }
        }
        return prop;
    }

    public static String nodeToString(Node node, String indent) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        switch (node.getNodeType()) {
            case 9: {
                printWriter.println("<xml version=\"1.0\">\n");
                NodeList nodes = node.getChildNodes();
                if (nodes == null) break;
                for (int i = 0; i < nodes.getLength(); ++i) {
                    printWriter.print(DomProbe.nodeToString(nodes.item(i), ""));
                }
                break;
            }
            case 1: {
                String name = node.getNodeName();
                printWriter.print(indent + "<" + name);
                NamedNodeMap attributes = node.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node current = attributes.item(i);
                    printWriter.print(" " + current.getNodeName() + "=\"" + current.getNodeValue() + "\"");
                }
                printWriter.print(">");
                NodeList children = node.getChildNodes();
                if (children != null) {
                    for (int i = 0; i < children.getLength(); ++i) {
                        printWriter.print(DomProbe.nodeToString(children.item(i), indent + indent));
                    }
                }
                printWriter.print("</" + name + ">");
                break;
            }
            case 3: {
                printWriter.print(node.getNodeValue());
            }
        }
        printWriter.flush();
        String result = stringWriter.getBuffer().toString();
        printWriter.close();
        return result;
    }
}

