/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.result.loader;

import com.ibatis.common.beans.ClassInfo;
import com.ibatis.sqlmap.engine.impl.SqlMapClientImpl;
import com.ibatis.sqlmap.engine.mapping.result.loader.ResultLoader;
import com.ibatis.sqlmap.engine.type.DomTypeMarker;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.LazyLoader;
import net.sf.cglib.proxy.NoOp;

public class EnhancedLazyResultLoader {
    private static final Class[] SET_INTERFACES = new Class[]{Set.class};
    private static final Class[] LIST_INTERFACES = new Class[]{List.class};
    private Object loader;

    public EnhancedLazyResultLoader(SqlMapClientImpl client, String statementName, Object parameterObject, Class targetType) {
        this.loader = new EnhancedLazyResultLoaderImpl(client, statementName, parameterObject, targetType);
    }

    public Object loadResult() throws SQLException {
        return ((EnhancedLazyResultLoaderImpl)this.loader).loadResult();
    }

    private static class EnhancedLazyResultLoaderImpl
    implements LazyLoader {
        protected SqlMapClientImpl client;
        protected String statementName;
        protected Object parameterObject;
        protected Class targetType;
        protected boolean loaded;
        protected Object resultObject;

        public EnhancedLazyResultLoaderImpl(SqlMapClientImpl client, String statementName, Object parameterObject, Class targetType) {
            this.client = client;
            this.statementName = statementName;
            this.parameterObject = parameterObject;
            this.targetType = targetType;
        }

        public Object loadResult() throws SQLException {
            if (DomTypeMarker.class.isAssignableFrom(this.targetType)) {
                return ResultLoader.getResult(this.client, this.statementName, this.parameterObject, this.targetType);
            }
            if (Collection.class.isAssignableFrom(this.targetType)) {
                if (Set.class.isAssignableFrom(this.targetType)) {
                    return Enhancer.create(Object.class, (Class[])SET_INTERFACES, (Callback)this);
                }
                return Enhancer.create(Object.class, (Class[])LIST_INTERFACES, (Callback)this);
            }
            if (this.targetType.isArray() || ClassInfo.isKnownType(this.targetType)) {
                return ResultLoader.getResult(this.client, this.statementName, this.parameterObject, this.targetType);
            }
            return Enhancer.create((Class)this.targetType, (Callback)this);
        }

        public Object loadObject() throws Exception {
            try {
                Object result = ResultLoader.getResult(this.client, this.statementName, this.parameterObject, this.targetType);
                if (result == null) {
                    result = Enhancer.create((Class)this.targetType, (Callback)NoOp.INSTANCE);
                }
                return result;
            }
            catch (SQLException e) {
                throw new RuntimeException("Error lazy loading result. Cause: " + String.valueOf(e), e);
            }
        }
    }
}

