/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.cdi;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionManager;
import org.mybatis.cdi.MybatisCdiConfigurationException;

@ApplicationScoped
public class SqlSessionManagerRegistry {
    private Map<SqlSessionFactory, SqlSessionManager> managers;
    @Inject
    @Any
    private Instance<SqlSessionFactory> factories;

    @PostConstruct
    public void init() {
        if (this.factories.isUnsatisfied()) {
            throw new MybatisCdiConfigurationException("There are no SqlSessionFactory producers properly configured.");
        }
        HashMap<SqlSessionFactory, SqlSessionManager> m = new HashMap<SqlSessionFactory, SqlSessionManager>();
        for (SqlSessionFactory factory : this.factories) {
            SqlSessionManager manager = SqlSessionManager.newInstance((SqlSessionFactory)factory);
            m.put(factory, manager);
        }
        this.managers = Collections.unmodifiableMap(m);
    }

    public SqlSessionManager getManager(SqlSessionFactory factory) {
        return this.managers.get(factory);
    }

    public Collection<SqlSessionManager> getManagers() {
        return this.managers.values();
    }
}

