/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.cdi;

import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.util.AnnotationLiteral;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.cdi.MybatisCdiConfigurationException;
import org.mybatis.cdi.SqlSessionManagerRegistry;

public final class CDIUtils {
    private CDIUtils() {
    }

    public static SqlSessionManagerRegistry getRegistry(CreationalContext creationalContext) {
        BeanManager beanManager = CDI.current().getBeanManager();
        Iterator beans = beanManager.getBeans(SqlSessionManagerRegistry.class, new Annotation[0]).iterator();
        return (SqlSessionManagerRegistry)beanManager.getReference((Bean)beans.next(), SqlSessionManagerRegistry.class, creationalContext);
    }

    public static SqlSessionFactory findSqlSessionFactory(String name, Set<Annotation> qualifiers, CreationalContext creationalContext) {
        Set beans;
        BeanManager beanManager = CDI.current().getBeanManager();
        Bean bean = beanManager.resolve(beans = name != null ? beanManager.getBeans(name) : beanManager.getBeans(SqlSessionFactory.class, qualifiers.toArray(new Annotation[0])));
        if (bean == null) {
            throw new MybatisCdiConfigurationException("There are no SqlSessionFactory producers properly configured.");
        }
        return (SqlSessionFactory)beanManager.getReference(bean, SqlSessionFactory.class, creationalContext);
    }

    public static class SerializableAnyAnnotationLiteral
    extends AnnotationLiteral<Any> {
        private static final long serialVersionUID = 1L;
    }

    public static class SerializableDefaultAnnotationLiteral
    extends AnnotationLiteral<Default> {
        private static final long serialVersionUID = 1L;
    }
}

