/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.util;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.mybatis.dynamic.sql.SqlColumn;
import org.mybatis.dynamic.sql.util.AbstractColumnMapping;
import org.mybatis.dynamic.sql.util.ColumnMappingVisitor;

public class ValueOrNullMapping<T>
extends AbstractColumnMapping {
    private final Supplier<T> valueSupplier;
    private final SqlColumn<T> localColumn;

    private ValueOrNullMapping(SqlColumn<T> column, Supplier<T> valueSupplier) {
        super(column);
        this.valueSupplier = Objects.requireNonNull(valueSupplier);
        this.localColumn = Objects.requireNonNull(column);
    }

    public Optional<Object> value() {
        return Optional.ofNullable(this.localColumn.convertParameterType(this.valueSupplier.get()));
    }

    @Override
    public <R> R accept(ColumnMappingVisitor<R> visitor) {
        return visitor.visit(this);
    }

    public static <T> ValueOrNullMapping<T> of(SqlColumn<T> column, Supplier<T> valueSupplier) {
        return new ValueOrNullMapping<T>(column, valueSupplier);
    }
}

