/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.select.OrderByModel;
import org.mybatis.dynamic.sql.select.PagingModel;
import org.mybatis.dynamic.sql.select.QueryExpressionModel;
import org.mybatis.dynamic.sql.select.render.SelectRenderer;
import org.mybatis.dynamic.sql.select.render.SelectStatementProvider;

public class SelectModel {
    private final List<QueryExpressionModel> queryExpressions;
    private final OrderByModel orderByModel;
    private final PagingModel pagingModel;

    private SelectModel(Builder builder) {
        this.queryExpressions = Objects.requireNonNull(builder.queryExpressions);
        this.orderByModel = builder.orderByModel;
        this.pagingModel = builder.pagingModel;
    }

    public <R> Stream<R> mapQueryExpressions(Function<QueryExpressionModel, R> mapper) {
        return this.queryExpressions.stream().map(mapper);
    }

    public Optional<OrderByModel> orderByModel() {
        return Optional.ofNullable(this.orderByModel);
    }

    public Optional<PagingModel> pagingModel() {
        return Optional.ofNullable(this.pagingModel);
    }

    @NotNull
    public SelectStatementProvider render(RenderingStrategy renderingStrategy) {
        return ((SelectRenderer.Builder)SelectRenderer.withSelectModel(this).withRenderingStrategy(renderingStrategy)).build().render();
    }

    public static Builder withQueryExpressions(List<QueryExpressionModel> queryExpressions) {
        return new Builder().withQueryExpressions(queryExpressions);
    }

    public static class Builder {
        private final List<QueryExpressionModel> queryExpressions = new ArrayList<QueryExpressionModel>();
        private OrderByModel orderByModel;
        private PagingModel pagingModel;

        public Builder withQueryExpression(QueryExpressionModel queryExpression) {
            this.queryExpressions.add(queryExpression);
            return this;
        }

        public Builder withQueryExpressions(List<QueryExpressionModel> queryExpressions) {
            this.queryExpressions.addAll(queryExpressions);
            return this;
        }

        public Builder withOrderByModel(OrderByModel orderByModel) {
            this.orderByModel = orderByModel;
            return this;
        }

        public Builder withPagingModel(PagingModel pagingModel) {
            this.pagingModel = pagingModel;
            return this;
        }

        public SelectModel build() {
            return new SelectModel(this);
        }
    }
}

