/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.insert.render;

import java.util.Objects;
import org.mybatis.dynamic.sql.insert.render.InsertStatementProvider;

public class DefaultInsertStatementProvider<T>
implements InsertStatementProvider<T> {
    private final String insertStatement;
    private final T record;
    private final T row;

    private DefaultInsertStatementProvider(Builder<T> builder) {
        this.insertStatement = Objects.requireNonNull(((Builder)builder).insertStatement);
        this.row = Objects.requireNonNull(((Builder)builder).row);
        this.record = this.row;
    }

    @Override
    public T getRecord() {
        return this.record;
    }

    @Override
    public T getRow() {
        return this.row;
    }

    @Override
    public String getInsertStatement() {
        return this.insertStatement;
    }

    public static <T> Builder<T> withRow(T row) {
        return new Builder<T>().withRow(row);
    }

    public static class Builder<T> {
        private String insertStatement;
        private T row;

        public Builder<T> withInsertStatement(String insertStatement) {
            this.insertStatement = insertStatement;
            return this;
        }

        public Builder<T> withRow(T row) {
            this.row = row;
            return this;
        }

        public DefaultInsertStatementProvider<T> build() {
            return new DefaultInsertStatementProvider(this);
        }
    }
}

