package org.mule.weave.v2.api.tooling.ts.catalog

import org.mule.weave.v2.api.tooling.ts.DWType

import java.util.Optional

trait DWTypeCatalog {
  def write(): String

  def getType(name: String): Optional[DWType]

  def getTypeNames: Array[String]
}

trait DWTypeCatalogLoader {

  def withType(name: String, weaveType: DWType): DWTypeCatalogLoader

  def withTypes(types: java.util.Map[String, DWType]): DWTypeCatalogLoader

  def withErrorHandler(callback: ErrorHandler): DWTypeCatalogLoader

  def fromCatalog(typeCatalog: String): DWTypeCatalog

  def build(): DWTypeCatalog
}

trait ErrorHandler {
  def onError(errorMessages: Array[String]): Unit
}
