package org.mule.weave.v2.runtime.exception

import org.mule.weave.v2.core.functions.WriteFunctionValue
import org.mule.weave.v2.core.exception.ExecutionException
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.parser.location.Location

class NoMatchFoundException(override val location: Location, value: Value[_])(implicit ctx: EvaluationContext) extends ExecutionException {
  override def message = s"None of the match cases matched: `${value.valueType.name}(${WriteFunctionValue.toDwString(value, WriteFunctionValue.maxValueLength)})`.\nTIP: Use `else -> <expression>` to match other cases."
}
