package org.mule.weave.v2.runtime.exception

import org.mule.weave.v2.core.functions.WriteFunctionValue
import org.mule.weave.v2.core.exception.ExecutionException
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.Type
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.parser.location.Location
import org.mule.weave.v2.utils.StringHelper

class InvalidObjectExpansionException(val location: Location, val from: Type, val value: Value[_])(implicit ctx: EvaluationContext) extends ExecutionException {

  override def message = {
    val valueAsString = WriteFunctionValue.toDwString(value, WriteFunctionValue.maxValueLength)
    val abbreviatedValue = if (valueAsString.nonEmpty) s" (${StringHelper.abbreviate(valueAsString, 80)})" else ""
    "Invalid type provided for object expansion.\n\n" +
      "Expected: Array<Object> or Object\n" +
      "Actual: " + from.name + abbreviatedValue
  }
}

object InvalidObjectExpansionException {

  def apply(location: Location, value: Value[_])(implicit ctx: EvaluationContext): InvalidObjectExpansionException = {
    new InvalidObjectExpansionException(location, value.valueType, value)
  }
}