package org.mule.weave.v2.runtime.core.operator.math

import org.mule.weave.v2.core.functions.BinaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.AnyType
import org.mule.weave.v2.model.types.ArrayType
import org.mule.weave.v2.model.types.DateTimeType
import org.mule.weave.v2.model.types.TimeZoneType
import org.mule.weave.v2.model.values.ArrayValue
import org.mule.weave.v2.model.values.DateTimeValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.parser.location.WeaveLocation

class DateTimeRightShiftOperator(override val location: WeaveLocation) extends BinaryFunctionValue {
  override val L = DateTimeType

  override val R = TimeZoneType

  override def doExecute(leftValue: L.V, rightValue: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    DateTimeValue(leftValue.evaluate.withZoneSameInstant(rightValue.evaluate), this)
  }
}

class PrependArrayOperator(override val location: WeaveLocation) extends BinaryFunctionValue {

  override val L = AnyType

  override val R = ArrayType

  override def doExecute(leftValue: L.V, rightValue: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    ArrayValue(rightValue.evaluate.prepend(leftValue), this)
  }
}

