package org.mule.weave.v2.runtime.core.operator.logical

import org.mule.weave.v2.core.functions.UnaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.BooleanType
import org.mule.weave.v2.model.types.BooleanType
import org.mule.weave.v2.model.values.BooleanValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.parser.location.UnknownLocation
import org.mule.weave.v2.parser.location.WeaveLocation

class NotOperator(override val location: WeaveLocation) extends UnaryFunctionValue {
  override val R = BooleanType

  override def doExecute(v: R.V)(implicit executionContext: EvaluationContext): Value[Boolean] = {
    BooleanValue(!v.evaluate, this)
  }
}

object NotOperator extends NotOperator(UnknownLocation)
