package org.mule.weave.v2.runtime.core.functions.types

import org.mule.weave.v2.core.functions.UnaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types._
import org.mule.weave.v2.model.values.FunctionValue
import org.mule.weave.v2.model.values.TypeValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.parser.location.UnknownLocation
import org.mule.weave.v2.parser.location.WeaveLocation

object TypeOfAnyFunctionValue extends UnaryFunctionValue {
  override val R = AnyType

  override def doExecute(v: R.V)(implicit executionContext: EvaluationContext): Value[_] = {
    var typ: Type = Type.typeOf(v.evaluate, this)

    if (typ == FunctionType && v.isInstanceOf[FunctionValue]) {
      val fVal = v.asInstanceOf[FunctionValue]
      typ = new FunctionType(Some(fVal.functionParamTypes), fVal.returnType)
    }

    TypeValue(typ.withSchema(v.schema), this)
  }
}

