package org.mule.weave.v2.runtime.core.functions.stringops

import org.mule.weave.v2.core.functions.BinaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.capabilities.UnknownLocationCapable
import org.mule.weave.v2.model.structure.ArraySeq
import org.mule.weave.v2.model.types.RegexType
import org.mule.weave.v2.model.types.StringType
import org.mule.weave.v2.model.values.ArrayValue
import org.mule.weave.v2.model.values.StringValue
import org.mule.weave.v2.model.values.Value

import java.util.regex.Pattern

trait SplitRegexFunctionValue extends BinaryFunctionValue {
  def splitWithRegex(pattern: Pattern, input: String)(implicit ctx: EvaluationContext): ArrayValue = {
    val split: Array[String] = ctx.serviceManager.patternService.split(pattern, input, this)
    ArrayValue(ArraySeq(split.map(StringValue(_, UnknownLocationCapable))), UnknownLocationCapable)
  }
}

object StringSplitStringFunctionValue extends SplitRegexFunctionValue {
  override val L = StringType
  override val R = StringType

  override def doExecute(leftValue: L.V, rightValue: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    val pattern: Pattern = Pattern.compile(scala.util.matching.Regex.quote(rightValue.evaluate.toString))
    splitWithRegex(pattern, leftValue.evaluate.toString)
  }
}

object StringSplitRegexFunctionValue extends SplitRegexFunctionValue {
  override val L = StringType
  override val R = RegexType

  override def doExecute(leftValue: L.V, rightValue: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    splitWithRegex(rightValue.evaluate.pattern, leftValue.evaluate.toString)
  }
}

