package org.mule.weave.v2.runtime.core.functions.stringops

import org.mule.weave.v2.core.functions.UnaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.NumberType
import org.mule.weave.v2.model.types.StringType
import org.mule.weave.v2.model.values._
import org.mule.weave.v2.runtime.core.exception.EmptyStringException

object CharCodeFunctionValue extends UnaryFunctionValue {
  override val R = StringType

  override def doExecute(v: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    val content: String = v.evaluate.toString
    if (content.isEmpty) {
      throw new EmptyStringException(this.location())
    }
    NumberValue(content.codePointAt(0))
  }
}

object FromCharCodeFunctionValue extends UnaryFunctionValue {
  override val R = NumberType

  override def doExecute(v: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    StringValue(v.evaluate.toInt.toChar.toString)
  }
}
