package org.mule.weave.v2.runtime.core.functions.math

import org.mule.weave.v2.core.functions.BinaryFunctionValue
import org.mule.weave.v2.core.exception.PowOverflowException
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.NumberType
import org.mule.weave.v2.model.values.NumberValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.model.values.math.Number
import org.mule.weave.v2.runtime.core.exception.ExponentOutOfBoundsException
import org.mule.weave.v2.runtime.core.exception.NegativeExponentException

object PowNumberFunctionValue extends BinaryFunctionValue {
  override val L = NumberType
  override val R = NumberType

  override def doExecute(l: R.V, r: R.V)(implicit executionContext: EvaluationContext): Value[_] = {
    val base: Number = l.evaluate
    val expo: Number = r.evaluate
    if (expo.<(0)) {
      throw new NegativeExponentException(expo.toString, r.location())
    }
    if (expo > 99999999) {
      throw new ExponentOutOfBoundsException(expo.toString, r.location())
    }
    try {
      NumberValue(base.pow(expo), this)
    } catch {
      case ae: ArithmeticException => {
        throw new PowOverflowException(location(), base.toString, expo.toString, ae.getMessage)
      }
    }
  }
}
