package org.mule.weave.v2.runtime.core.functions.date

import org.mule.weave.v2.core.functions.UnaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.DateTimeType
import org.mule.weave.v2.model.types.LocalDateTimeType
import org.mule.weave.v2.model.types.LocalDateType
import org.mule.weave.v2.model.values.BooleanValue
import org.mule.weave.v2.model.values.Value

object LeapLocalDateFunctionValue extends UnaryFunctionValue {
  override val R = LocalDateType

  override def doExecute(v: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    BooleanValue(v.evaluate.isLeapYear)
  }
}

object LeapDateTimeFunctionValue extends UnaryFunctionValue {
  override val R = DateTimeType

  override def doExecute(v: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    BooleanValue(v.evaluate.toLocalDate.isLeapYear)
  }
}

object LeapLocalDateTimeFunctionValue extends UnaryFunctionValue {
  override val R = LocalDateTimeType

  override def doExecute(v: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    BooleanValue(v.evaluate.toLocalDate.isLeapYear)
  }
}
