package org.mule.weave.v2.runtime.core.functions.collections

import org.mule.weave.v2.core.functions.BinaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.{ ArrayType, FunctionType, StringType }
import org.mule.weave.v2.model.values._

object ArrayReduceFunctionValue extends BinaryFunctionValue {
  override val L = ArrayType

  override val R = FunctionType

  def doReduce(initialAcc: Value[_], values: Iterator[Value[_]], fun: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    var acc = initialAcc
    while (values.hasNext) {
      acc = fun.call(values.next(), acc)
    }
    acc
  }

  override def doExecute(lhs: L.V, rhs: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    val values: Iterator[Value[_]] = lhs.evaluate.toIterator()
    val value = rhs.parameters.lift(1).flatMap(_.value)
    var acc: Value[_] = NullValue
    if (value.isDefined) {
      acc = value.get.value()
    } else if (values.hasNext) {
      acc = values.next().materialize
    }
    doReduce(acc, values, rhs)
  }
}

object StringReduceFunctionValue extends BinaryFunctionValue {
  override val L = StringType

  override val R = FunctionType

  def doReduce(initialAcc: Value[_], values: Iterator[Char], fun: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    var acc = initialAcc
    while (values.hasNext) {
      acc = fun.call(StringValue(values.next.toString), acc)
    }
    acc
  }

  override def doExecute(lhs: L.V, rhs: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    val str: Iterator[Char] = lhs.evaluate.toString.iterator
    val value = rhs.parameters.lift(1).flatMap(_.value)
    var acc: Value[_] = NullValue
    if (value.isDefined) {
      acc = value.get.value()
    } else if (str.hasNext) {
      acc = StringValue(str.next().toString)
    } else {
      acc = StringValue("")
    }
    doReduce(acc, str, rhs)
  }
}
