package org.mule.weave.v2.runtime.core.functions.collections

import org.mule.weave.v2.core.functions.BinaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.KeyValuePair
import org.mule.weave.v2.model.structure.QualifiedName
import org.mule.weave.v2.model.types.FunctionType
import org.mule.weave.v2.model.types.ObjectType
import org.mule.weave.v2.model.values._
import org.mule.weave.v2.model.values.math.Number

object PluckObjectFunctionValue extends BinaryFunctionValue {

  val L = ObjectType

  val R = FunctionType

  override def doExecute(lhs: L.V, rhs: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    val result = new PluckArrayValue(lhs.evaluate.toIterator(), rhs)
    ArrayValue(result, this)
  }
}

class PluckArrayValue(keyValuePairs: Iterator[KeyValuePair], rhs: FunctionType.V)(implicit ctx: EvaluationContext) extends Iterator[Value[_]] {

  var i = 0
  override def hasNext: Boolean = {
    val nextKVP = keyValuePairs.hasNext
    nextKVP
  }

  override def next(): Value[_] = {
    val ekv = keyValuePairs.next()
    val key: Value[QualifiedName] = ekv._1
    val value: Value[_] = ekv._2
    val indexValue: NumberValue = NumberValue(Number(i))
    val ret: Value[_] = rhs.call(AttributeDelegateValue(value, key), key, indexValue)
    i += 1
    ret
  }
}