package org.mule.weave.v2.runtime.core.functions.collections

import org.mule.weave.v2.core.functions.BinaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.ArraySeq
import org.mule.weave.v2.model.types.ArrayType
import org.mule.weave.v2.model.types.FunctionType
import org.mule.weave.v2.model.values.ArrayValue
import org.mule.weave.v2.model.values.NumberValue
import org.mule.weave.v2.model.values.Value
object ArrayMapFunctionValue extends BinaryFunctionValue {
  val L = ArrayType

  val R = FunctionType

  override def doExecute(leftValue: L.V, rightValue: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    var i: Int = 0
    val arraySeq: ArraySeq = leftValue.evaluate
    val mappedValue = arraySeq.toIterator().map((v: Value[_]) => {
      val result: Value[_] = rightValue.call(v, NumberValue(i))
      i = i + 1
      result
    })
    ArrayValue(mappedValue, this)
  }
}

