package org.mule.weave.v2.runtime.core.functions.binary

import org.mule.weave.v2.core.functions.BinaryFunctionValue
import org.mule.weave.v2.core.io.MemoryService
import org.mule.weave.v2.core.io.SeekableStream
import org.mule.weave.v2.core.io.service.WorkingDirectoryService
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.service.SettingsService
import org.mule.weave.v2.model.types.ArrayType
import org.mule.weave.v2.model.types.StringType
import org.mule.weave.v2.model.values.BinaryValue
import org.mule.weave.v2.model.values.BinaryValue.getSizeFromInputStream
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.module.reader.DefaultAutoPersistedOutputStream

import java.io.OutputStream
import java.nio.charset.Charset

object WriteLinesFunctionValue extends BinaryFunctionValue {

  override val L = ArrayType

  override val R = StringType

  override def doExecute(leftValue: L.V, rightValue: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    val linesArray = leftValue.evaluate
    val charset = Charset.forName(rightValue.evaluate.toString)
    val byteses = linesArray.toIterator().map((item) => StringType.coerce(item).evaluate.toString.getBytes(charset))
    BinaryValue(new IteratorSeekableInputStream(byteses, "\n".getBytes(charset), ctx.serviceManager.workingDirectoryService, ctx.serviceManager.memoryService, ctx.serviceManager.settingsService))
  }

}

class IteratorSeekableInputStream(byteses: Iterator[Array[Byte]], newLine: Array[Byte], fileService: WorkingDirectoryService, memoryService: MemoryService, settingsService: SettingsService)(implicit ctx: EvaluationContext) extends SeekableStream {

  private var consumed = false

  private lazy val stream: SeekableStream = {
    consumed = true
    val stream = new DefaultAutoPersistedOutputStream(fileService, memoryService, settingsService)
    byteses.foreach((b) => {
      stream.write(b)
      stream.write(newLine)
    })
    stream.toInputStream
  }

  override def position(): Long = stream.position()

  override def seek(position: Long): Unit = {
    if (!(position == 0 && !consumed)) {
      stream.seek(position)
    }
  }

  override def requireClose(): Boolean = true

  override def spinOff()(implicit ctx: EvaluationContext): SeekableStream = stream.spinOff()

  override def inMemoryStream(): Boolean = stream.inMemoryStream()

  override def close(deleteFile: Boolean): Unit = {
    if (consumed) {
      stream.close()
    }
  }

  override def read(): Int = stream.read()

  override def copyTo(mayBeTarget: Option[OutputStream])(implicit ctx: EvaluationContext): OutputStream = {
    if (!consumed && mayBeTarget.isDefined) {
      byteses.foreach((buffer) => {
        mayBeTarget.get.write(buffer)
        mayBeTarget.get.write(newLine)
      })
      mayBeTarget.get
    } else {
      stream.copyTo(mayBeTarget)
    }
  }

  override def size(): Long = {
    seek(0)
    getSizeFromInputStream(this, memoryService)
  }
}
