package org.mule.weave.v2.interpreted.node.structure.header.directives

import org.mule.weave.v2.interpreted.EmptyExecutionContext
import org.mule.weave.v2.interpreted.ExecutionContext

class OutputDirective(val mime: Option[ContentType], val options: Option[Seq[DirectiveOption]], id: Option[String]) extends Directive with Configurable {
  override def productElement(n: Int): Any = n match {
    case 0 => mime.orNull
    case 1 => options.orNull
    case 2 => id.orNull
  }

  def getOptionValue(name: String): Option[String] = {
    val evaluationContext: ExecutionContext = EmptyExecutionContext()
    val encoding: Option[DirectiveOption] = options match {
      case Some(opts) =>
        opts.find((option) => {
          option._1.execute(evaluationContext).evaluate(evaluationContext).toString.equals(name)
        })
      case _ => None
    }
    encoding.map(_._2.execute(evaluationContext).evaluate(evaluationContext).toString)
  }

  private def toIncrease(field: Option[_]): Int = {
    if (field.isDefined) 1 else 0
  }

  override def productArity: Int = {
    var arity = 0
    arity += toIncrease(options)
    arity += toIncrease(mime)
    arity += toIncrease(id)
    arity
  }
}
