package org.mule.weave.v2.interpreted.node.structure

import org.mule.weave.v2.interpreted.ExecutionContext
import org.mule.weave.v2.interpreted.node.ValueNode
import org.mule.weave.v2.model.structure.NameValuePair
import org.mule.weave.v2.model.structure.QualifiedName
import org.mule.weave.v2.model.types.BooleanType
import org.mule.weave.v2.model.values.NameValuePairValue
import org.mule.weave.v2.model.values.Value

class NameValuePairNode(val key: ValueNode[QualifiedName], val value: ValueNode[_], val cond: Option[ValueNode[_]]) extends ValueNode[NameValuePair] with ConditionalCapableNode {
  override def doExecute(implicit ctx: ExecutionContext): Value[NameValuePair] = NameValuePairValue(NameValuePair(key.execute, value.execute), this)

  override def condition(implicit ctx: ExecutionContext): Boolean = cond match {
    case Some(condNode) => BooleanType.coerce(condNode.execute, this).evaluate
    case _              => true
  }

  override def productElement(n: Int): Any = {
    n match {
      case 0 => key
      case 1 => value
      case 2 => cond.get
    }
  }

  override def productArity: Int = {
    if (cond.isDefined) 3 else 2
  }

}

object NameValuePairNode {
  def apply(key: ValueNode[QualifiedName], value: ValueNode[_], cond: Option[ValueNode[_]] = None) = new NameValuePairNode(key, value, cond)
}