package org.mule.weave.v2.interpreted.node.expressions

import org.mule.weave.v2.interpreted.ExecutionContext
import org.mule.weave.v2.interpreted.node.NameSlot
import org.mule.weave.v2.interpreted.node.ValueNode
import org.mule.weave.v2.interpreted.node.structure.header.directives.VarDirective
import org.mule.weave.v2.model.values.Value

/**
  * Executes all the set variables but under the same context
  *
  */
class InlineTailRecFunctionCall(val expressions: Array[VarDirective]) extends ValueNode[Any] with Product {

  override def productArity: Int = expressions.length

  override def productElement(n: Int): VarDirective = expressions(n)

  override protected def doExecute(implicit ctx: ExecutionContext): Value[Any] = {
    //We need to execute all the values before updating variables so that they are all executed in the same context
    val tuples = new Array[(NameSlot, Value[Any])](expressions.length)
    var i = 0
    while (i < expressions.length) {
      val vard = expressions(i)
      val value = if (vard.materialize) {
        vard.literal.execute.materialize
      } else {
        vard.literal.execute
      }
      tuples.update(i, (vard.variable, value))
      i = i + 1
    }
    throw new ReturnVariablesException(tuples)
  }
}
